#
# Cookbook Name:: ganglia
# Recipe:: gmetad
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

gmetad_service = nil
case node[:platform_family]
  when 'debian'
    package 'gmetad' do
      action :install
    end

    gmetad_service = 'gmetad'
    service gmetad_service do
      action [:enable]
      supports :status => false, :restart => true, :reload => false
    end
  when 'rhel'
    package 'ganglia-gmetad' do
      action :install
      options '--disablerepo=HDP-UTILS*'
    end

    gmetad_service = 'gmetad'
    service gmetad_service do
      action [:enable]
      supports :status => false, :restart => true, :reload => false
    end
end

template '/etc/ganglia/gmetad.conf' do
  source 'etc/ganglia/gmetad.conf'
  owner 'root'
  group 'root'
  mode '0644'
  notifies :restart, "service[#{gmetad_service}]"
end

