#
# Cookbook Name:: hadoop
# Recipe:: build
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

::Chef::Recipe.send(:include, Hadoop::Helper)

packages = nil

deb_packages = [
  'ant',
  'build-essential',
  'autoconf',
  'libtool',
  # for libhadoop
  'zlib1g-dev',
  # for libhadooppipes
  'libssl-dev',
]

rpm_packages = [
  'ant',
  'gcc-c++',
  'make',
  'autoconf',
  'automake',
  'libtool',
  # for libhadoop
  'zlib-devel',
  # for libhadooppipes
  'openssl-devel',
]

case node[:platform_family]
when 'debian'
  packages = deb_packages
when 'rhel'
  packages = rpm_packages
end

version, major_version, middle_version \
  = parse_version_number(node['hadoop']['version'])

if middle_version >= '2.0' then
  packages = packages \
    + [
      'cmake',
    ]
end

if middle_version >= '2.1' then
  packages = packages \
    + [
      # for libhdfs
      node.value_for_platform_family(
        'debian' => 'pkg-config',
        'rhel'   => 'pkgconfig'
      )
    ]
end

packages.each {|pkg|
  resources(:package => pkg) rescue package pkg do
    action :install
  end
}

log <<-EOM
Please Check:
Extra requirements must be installed by the other recipes or roles.:
  Hadoop 1.x:
    Oracle JDK6
    Apache Maven 3.x
    protobuf-compiler 2.4.1
  Hadoop 2.x:
    Oracle JDK6
    Apache Maven 3.x
    protobuf-compiler 2.5.0
EOM

