/* WCECommDriver.java --
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.javax.comm.wce;


import javax.comm.*;

public class WCECommDriver implements CommDriver {
	
	private static final int MINIMUM_PORT = Integer.getInteger("gnu.javax.comm.wce.minimumPort", 1).intValue();
	private static final int MAXIMUM_PORT = Integer.getInteger("gnu.javax.comm.wce.maximumPort", 9).intValue();
	
	public void initialize() {
		System.loadLibrary("javaxcomm");
		
		// VA|[gꗗo^
		for (int i = MINIMUM_PORT; i <= MAXIMUM_PORT; ++i) {
			CommPortIdentifier.addPortName("COM" + i + ":",
										   CommPortIdentifier.PORT_SERIAL,
										   this);
		}
		
		// ToDo:p|[g̏
	}
	
	public CommPort getCommPort(String portName,
								int portType) {
		int nativeHandle = getNativeHandle(portName, portType);
		if (nativeHandle == 0) {
			return null;
		}
		if (portType == CommPortIdentifier.PORT_SERIAL) {
			return new WCESerialPort(portName, nativeHandle);
		} else {
			throw new IllegalArgumentException("portType=" + portType + " is not supported");
		}
	}
	
	/**
	 * lCeBunh𓾂
	 */
	public native int getNativeHandle(String name, int type);
	
}
