/* console.cpp
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/

#include "StdAfx.h"
#include "console.h"
#include "resource.h"

/**
 * R\[EChẼnh
 */
static HWND g_hwndConsole;

/**
 * HINSTANCE
 */
static HINSTANCE g_hInstance;

/**
 * o̓obt@̍ős
 */
#define	MAX_OUTPUT_LINE_COUNT	100

/**
 * _CNg
 */
static HANDLE g_hLogFile;

/**
 * ̓obt@̃CxgIuWFNg
 */
static HANDLE g_hInputEvent;

/**
 * R\[\ɂȂƂCxgIuWFNg
 */
static HANDLE g_hClosedEvent;

/**
 * ̓Rg[̃EChEvV[W
 */
WNDPROC g_wndprocInput;

/**
 * _CAOvV[W
 */
LRESULT CALLBACK ConsoleDialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

/**
 * _CAOvV[W
 */
LRESULT CALLBACK InputWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

/**
 * _CAÕCAEgs
 */
static void layoutConsoleDialog(HWND hDlg);

/**
 * stdio݂邩?
 */
BOOL g_use_stdio;

/**
 * R\[EChE쐬
 */
void console_init(HINSTANCE hInstance, HWND hwndParent, bool use_stdio) {
	g_hInstance = hInstance;

	// R\[_CAO
	g_hwndConsole = CreateDialog(hInstance,
								 MAKEINTRESOURCE(IDD_CONSOLE),
								 hwndParent,
								 (DLGPROC) ConsoleDialogProc);
	
	// ʒmpCxg
	g_hInputEvent = CreateEvent(NULL,
								TRUE,	// }jAZbg
								FALSE,	// 
								NULL);

	g_hClosedEvent = CreateEvent(NULL,
								 FALSE,	// I[gZbg
								 TRUE,	// 
								 NULL);
#if 0
	// GetStdiuPathW()ł͊mFłȂ(?)
	HMODULE hModule = GetModuleHandle(_T("coredll"));
	if (hModule) {
		typedef BOOL(*GET_STUDIO_PATH_W)(DWORD, PWSTR, LPDWORD);
		WCHAR buf[MAX_PATH];

		GET_STUDIO_PATH_W get_stdio_path_w = (GET_STUDIO_PATH_W) GetProcAddress(hModule, _T("GetStdioPathW"));
		if (get_stdio_path_w) {
			DWORD len = MAX_PATH;
			int result = get_stdio_path_w(0, buf, &len);
			if (result && len > 0) {
				g_use_stdio = true;
			}
		}
	}
#endif
	g_use_stdio = use_stdio;

}


/**
 * R\[EChE̕\^\؂ւ
 */
void console_set_visible(bool visible) {
	if (visible) {
		ResetEvent(g_hClosedEvent);
		ShowWindow(g_hwndConsole, SW_SHOW);
		UpdateWindow(g_hwndConsole);
		SetForegroundWindow(g_hwndConsole);
	} else {
		SetEvent(g_hClosedEvent);
		ShowWindow(g_hwndConsole, SW_HIDE);
	}
}

/**
 * R\[\Ԃ̏ꍇA\ɂȂ܂őҋ@
 */
void console_wait_for_close() {
	if (IsWindowVisible(g_hwndConsole)) {
		console_write(_T("JVM exit"));
		SetForegroundWindow(g_hwndConsole);
		WaitForSingleObject(g_hClosedEvent, INFINITE);
	}
}

/**
 * R\[ɂPo͂
 */
void console_write(_TCHAR c) {
	_TCHAR text[2] = { c, _T('\0') };
	console_write(text);
}

/**
 * R\[ɕo͂
 */
void console_write(const _TCHAR* text) {
	if (g_use_stdio) {
		_fputts(text, stdout);
	}
	HWND hwndOutput = GetDlgItem(g_hwndConsole, IDC_CONSOLE_OUTPUT);
	
	// s𒴂ꍇA擪̍s폜
	// XN[ʒu擪ɖ߂Ă܂߁AȂׂĂяo񐔂炷		
	int linecount = SendMessage(hwndOutput, EM_GETLINECOUNT, 0, 0);
	if (linecount >= MAX_OUTPUT_LINE_COUNT * 2) {
		// őŝQ{𒴂ꍇɂ̂ݏs
		int lineindex = SendMessage(hwndOutput, EM_LINEINDEX, MAX_OUTPUT_LINE_COUNT, 0);
		if (lineindex != -1) {
			SendMessage(hwndOutput, EM_SETSEL, (WPARAM) 0, (LPARAM) lineindex);
			SendMessage(hwndOutput, EM_REPLACESEL, (WPARAM) FALSE, (LPARAM) _T(""));
		}
	}

	int len = _tcslen(text);
	const _TCHAR* pout = text;
	const _TCHAR* work = pout;
	_TCHAR* tmp = NULL;
	const size_t tmp_size = sizeof(_TCHAR) * (len + 2 + 1);	//  + \r\n + \0
	while ((work = _tcschr(work, _T('\n'))) != NULL) {
		if (work == text || (work != text && *(work - 1) != _T('\r'))) {
			// '\n' PƂŏoꍇ
			if (! tmp) {
				tmp = (_TCHAR*) calloc(tmp_size, 1);
				if (! tmp) {
					// s̏ꍇ̓X[
					continue;
				}
			} else {
				memset(tmp, 0, tmp_size);
			}
			_tcsncpy(tmp, pout, (work - pout));
			_tcscat(tmp, _T("\r\n"));
			// Iɏo͂
			int pos = GetWindowTextLength(hwndOutput);
			SendMessage(hwndOutput, EM_SETSEL, (WPARAM) pos, (WPARAM) pos);
			SendMessage(hwndOutput, EM_REPLACESEL, (WPARAM) FALSE, (LPARAM) tmp);

			// o͊Jnʒu炷
			pout = ++work;
		} else {
			work++;
		}
	}
	free(tmp);

	// ɕǉ
	int pos = GetWindowTextLength(hwndOutput);
	SendMessage(hwndOutput, EM_SETSEL, (WPARAM) pos, (WPARAM) pos);
	SendMessage(hwndOutput, EM_REPLACESEL, (WPARAM) FALSE, (LPARAM) pout);

	// R\[Ot@Cɏo͂
	if (g_hLogFile) {
		DWORD count;
		WriteFile(g_hLogFile,
				  text,
				  _tcslen(text) * sizeof(_TCHAR),
				  &count,
				  NULL);
	}
}

/**
 * R\[當ǂݍ
 */
int console_read(_TCHAR* buff, int len) {
	if (! len) {
		return 0;
	}
	// KQoCg̔{ł邱
	assert(! (len & 0x01));

	int copylen = 0;
	if (g_use_stdio && GetForegroundWindow() != g_hwndConsole) {
		// W͂ǂݍ
		_TCHAR* result = _fgetts(buff, len, stdin);
		if (! result) {
			copylen = -1;
		} else {
			copylen = _tcslen(buff);
		}
	} else {
		if (GetForegroundWindow() != g_hwndConsole) {
			SetForegroundWindow(g_hwndConsole);
		}

		// R\[ǂݍ
		// ǂݍ݉\ɂȂ܂őҋ@
		WaitForSingleObject(g_hInputEvent, INFINITE);

		// ǂݎpɂ
		HWND hwndInput = GetDlgItem(g_hwndConsole, IDC_CONSOLE_INPUT);
		SendMessage(hwndInput, EM_SETREADONLY, (WPARAM) TRUE, 0);

		// Rs[钷肷
		int textlen = GetWindowTextLength(hwndInput) + 2;	// sǉ
		copylen = (len < textlen) ? len : textlen;
		
		// eLXg擾
		GetWindowText(hwndInput, buff, copylen);
		
		// sǉ
		if (textlen == copylen) {
			_tcscat(buff, _T("\r\n"));
		}

		// eLXgIԂɂāAǂݍ񂾔͈͂̕NA
		SendMessage(hwndInput,
					EM_SETSEL,
					(WPARAM) 0,				// 擪
					(LPARAM) copylen		// 
					);
		SendMessage(hwndInput,
					EM_REPLACESEL,
					(WPARAM) FALSE,			// UNDOsv
					(LPARAM) _T("")			// 󕶎
					);
		
		if (! GetWindowTextLength(hwndInput)) {
			// ǂݍޕȂꍇ́AҏW\ɖ߂
			SendMessage(hwndInput, EM_SETREADONLY, (WPARAM) FALSE, 0);
			ResetEvent(g_hInputEvent);
		}

		// GR[obNisvHj
		_TCHAR echoback_buff[128 + 1];
		int remains = copylen;
		while (remains > 0) {
			int echolen = remains < 128 ? remains : 128;
			_tcsncpy(echoback_buff, buff, echolen);
			echoback_buff[echolen] = _T('\0');
			console_write(echoback_buff);
			remains -= echolen;
			buff += echolen;
		}
	}

	return copylen;	
}

/**
 * Ot@Cݒ肷
 */
void console_set_logfile(HANDLE out) {
	g_hLogFile = out;
}

/**
 * R\[_CAOvV[W
 */
LRESULT CALLBACK ConsoleDialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam) {
	static SHACTIVATEINFO sai;

	switch (message) {
		case WM_INITDIALOG:
			{
				sai.cbSize = sizeof(SHACTIVATEINFO);

				// ^Cgݒ肷
				SetWindowText(hDlg, _T("Mysaifu JVM console"));

				// _CAO{bNXő剻
				SHINITDLGINFO shidi = {0};
				shidi.dwMask = SHIDIM_FLAGS;
//				shidi.dwFlags = SHIDIF_SIZEDLGFULLSCREEN | SHIDIF_DONEBUTTON | SHIDIF_EMPTYMENU;
				shidi.dwFlags = SHIDIF_SIZEDLGFULLSCREEN | SHIDIF_DONEBUTTON;
				shidi.hDlg = hDlg;
				SHInitDialog(&shidi);

				layoutConsoleDialog(hDlg);
				
				// eLXg{bNXTuNX
				HWND hwndInput = GetDlgItem(hDlg, IDC_CONSOLE_INPUT);
				g_wndprocInput = (WNDPROC) GetWindowLong(hwndInput, GWL_WNDPROC);
				SetWindowLong(hwndInput, GWL_WNDPROC, (LONG) InputWndProc);
			
			}
			return TRUE;

		case WM_ACTIVATE:
			SHHandleWMActivate(hDlg, wParam, lParam, &sai, FALSE);
			return TRUE;

		case WM_SETTINGCHANGE:
			SHHandleWMSettingChange(hDlg, wParam, lParam, &sai);
     		return TRUE;

		case WM_SIZE:
			{
				// ăCAEg
				layoutConsoleDialog(hDlg);
			}
			return TRUE;

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
			case IDOK:
				console_set_visible(false);
			}
			return TRUE;
	}
	return FALSE;
}

/**
 * _CAÕCAEgs
 */
static void layoutConsoleDialog(HWND hDlg) {
	// o̓eLXg{bNX̃TCYAEChETCYɍ킹
	HWND hwndOutput = GetDlgItem(hDlg, IDC_CONSOLE_OUTPUT);
	HWND hwndInput = GetDlgItem(hDlg, IDC_CONSOLE_INPUT);

	RECT rect;
	GetWindowRect(hDlg, &rect);
	
	RECT rectInput;
	GetWindowRect(hwndInput, &rectInput);

	// o͗peLXg{bNX𒆉ɔzu
	int outputWidth = rect.right - rect.left;
	int outputHeight = (rect.bottom - rect.top) - (rectInput.bottom - rectInput.top);
	MoveWindow(hwndOutput,
				0,
				0,
				outputWidth,
				outputHeight,
				TRUE);

	// ͗peLXg{bNXԉɔzu
	int inputY = outputHeight;
	MoveWindow(hwndInput,
			   0,
			   inputY,
			   outputWidth,
			   (rectInput.bottom - rectInput.top),
			   TRUE);
}

/**
 * ̓GfBbgRg[
 */
LRESULT CALLBACK InputWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	switch (message) {
	case WM_CHAR:
		if (wParam == VK_RETURN) {
			// ^[L[ꂽ_ŃCxgʒm
			SetEvent(g_hInputEvent);
		}
		break;
	}
	return CallWindowProc(g_wndprocInput, hWnd, message, wParam, lParam);
}