/* class_loader.h
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/

#ifndef CLASS_LOADER_H_INCLUDED
#define CLASS_LOADER_H_INCLUDED

#include "ClassFile.h"
#include "frame.h"
#include "common_funcs.h"

/**
 * staticf[^̏Ԃ\萔
 */
/**
 * G[
 */
#define	STATIC_DATA_ERROR			-1

/**
 * mۂꂽ
 */
#define	STATIC_DATA_ALLOCATED		0

/**
 * 
 */
#define STATIC_DATA_INITIALIZING	1

/**
 * 
 */
#define STATIC_DATA_INITIALIZED		2

/**
 * NX[_
 * `͔J
 */
struct class_loader;
extern class_loader* g_bootstrap_class_loader;

/**
 * VerifyMode (in arguments.h)
 */
extern enum VerifyMode;

/**
 * AnnotationMode (in arguments.h)
 */
extern enum AnnotationMode;

/**
 * Initialize class loader.
 */
void init_class_loader_settings(VerifyMode verify_mode, AnnotationMode annotation_mode);

/**
 * u[gXgbvENX[_Ԃ
 */
inline class_loader* get_bootstrap_class_loader() {
	return g_bootstrap_class_loader;
}

/**
 * w肳ꂽClassFile\̂̒`NX[_Ԃ
 *
 */
inline class_loader* get_defining_loader(ClassFile* class_file) {
	return class_file->defining_loader;
}

/**
 * v~eBuNXClassFile\̂[h
 */
ClassFile* load_primitive_ClassFile(frame* frm, const java_utf8* class_name);

/**
 * v~eBuNXClassIuWFNg[h
 */
jclass find_primitive_class_object(frame* current_frame, jobject static_data);

/**
 * w肳ꂽClassFile\̂̒`NX[_Ԃ
 *
 */
class_loader* get_defining_loader(ClassFile* class_file);

/**
 * w肳ꂽNXpbP[WɑĂ邩Ԃ
 */
bool is_same_package(class_loader* loader, ClassFile* c1, ClassFile* c2);

/**
 * w肳ꂽClassFilẽNXIuWFNg
 * ݂ĂȂꍇNULLԂ
 *
 * @param	cfile	ΏۂƂȂClassFile\̂ւ̃|C^
 * @return	ΉNXIuWFNgB݂ȂꍇNULL
 */
jobject get_static_data(ClassFile* cfile);

/**
 * staticf[^̏ԂԂB
 */
int get_static_data_status(jobject static_data);

/**
 * staticf[^̏Ԃݒ肷
 */
void set_static_data_status(jobject static_data, int stat);

/**
 * JgXbhȊÕXbhstaticf[^ł邩
 * ԂB
 */
bool is_another_thread_initializing(jobject static_data);

/**
 * w肳ꂽ staticf[^ɑΉ java.lang.Class IuWFNgԂB
 */
jclass find_class_object(frame* current_frame, jobject static_data, jobject pd);

/**
 * w肳ꂽ OɑΉ郍[hς Class IuWFNgԂB
 * [hĂȂꍇNULLԂB
 */
jclass find_loaded_class_object(class_loader* loader, frame* current_frame, const java_utf8* name);

/**
 * w肳ꂽClassLoaderIuWFNgɑΉclass_loader\̂Ԃ
 */
class_loader* get_class_loader(jobject cl);

/**
 * w肳ꂽ class_loader \̂ɑΉ java.lang.ClassLoader ̃CX^XԂ
 */
jobject get_ClassLoader(class_loader* loader);

/**
 * w肳ꂽoCgz߂AClassFile\̂𐶐B
 *  loader Ŏw肳ꂽNX[_A`NX[_ƂċL^B
 */
ClassFile* define_ClassFile(frame* current_frame,
							const java_utf8* name,
							class_loader* loader,
							const char* buff,
							int offset,
							int length);

/**
 * u[gNXpX
 * xݒ肷ƁAύXłȂBij
 */
void init_boot_classpath(const _TCHAR* classpath);

/**
 * u[gNXpXԂ
 */
const _TCHAR* get_boot_classpath();

/**
 * VXeNXpX
 * xݒ肷ƁAύXłȂBij
 */
void init_system_classpath(const _TCHAR* classpath);

/**
 * VXeNXpXԂ
 */
const _TCHAR* get_system_classpath();

/**
 * w肳ꂽNX[_pāAw肳ꂽÕNX[h
 * w肳ꂽNXɂĂ̏istatic final tB[h̏<clinit>\bh̎sj
 * sB
 */
ClassFile* find_ClassFile(frame* frm, class_loader* loader, const java_utf8* class_name);

/**
 * u[gXgbvNX[_pāAw肳ꂽÕNX[h
 * w肳ꂽNXɂĂ̏istatic final tB[h̏<clinit>\bh̎sj
 * sB
 */
inline ClassFile* find_ClassFile(frame* frm, const java_utf8* class_name) {
	return find_ClassFile(frm, get_bootstrap_class_loader(), class_name);
}

/**
 * w肳ꂽNX[_[hNXɑ΂
 * xt@CKvǂԂB
 */
bool needs_verify(class_loader* loader);

/**
 * w肳ꂽtB[hfBXNv^Ɋւ郍[hǉ
 */
bool add_loading_constraints_of_field(frame* current_frame, ClassFile* declaring_ClassFile, const java_utf8* field_descriptor);

/**
 * w肳ꂽ\bhfBXNv^Ɋւ郍[hǉ
 */
bool add_loading_constraints_of_method(frame* current_frame, ClassFile* declaring_ClassFile, const java_utf8* method_descriptor);

/**
 * w肳ꂽ\bhfBXNv^Ɋւ郍[hǉ
 */
bool add_loading_constraints_of_method(frame* current_frame,
									   class_loader* loader1,
									   class_loader* loader2,
									   const java_utf8* descriptor);

/**
 * w肳ꂽNX[_gpPermanentHeapNXԂ
 */
PermanentHeap* get_heap_of_class_loader(class_loader* loader);

/**
 * Returns annotation load level.
 */
bool needs_visible_annotations(class_loader* loader);
bool needs_all_annotations(class_loader* loader);

#endif