/* jni_funcs.h
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.
*/


#ifndef JNI_FUNCS_H_INCLUDED
#define	JNI_FUNCS_H_INCLUDED

#include <jni.h>
#include "ClassFile.h"
#include "arguments.h"

/**
 * JNI֐
 */
void init_jni_funcs();

/**
 * w肳ꂽlCeBu\bhɑΉ֐̃|C^Ԃ
 */
void* find_native_proc_ptr(ClassFile* cfile, method_info* minfo);

void call_native_function(void* func_ptr, frame* caller_frame, ClassFile* target_class_file, method_info* target_method_info);

/**
 * CXbhJn
 */
bool start_main_thread(java_utf8* main_class_name, _TCHAR* argv, bool jar);

/**
 * ClassLoader.loadClass(String)\bhĂяoAClassFile\̂
 * ԂB
 */
ClassFile* call_loadClass(frame* current_frame, jobject cl, const char* name);

/**
 * assertion̗L^ݒ肷
 */
void set_assertion_status(bool enabled);

/**
 * JAVA_HOMEԂB
 */
const _TCHAR* get_java_home();

/**
 * ݂arguments𓾂
 */
arguments* get_current_arguments();

/**
 * ݂argumentsݒ肷B
 * i2ڈȍ~̌Ăяo͖j
 */
void set_current_arguments(arguments* args);

#endif