/* gnu_java_awt_peer_wce_WCEClipboard.c
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEClipboard.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEClipboard
 * Method:    setNativeString
 * Signature: (Ljava/awt/String;)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEClipboard_setNativeString(JNIEnv *env, jobject obj, jstring str) {
	HANDLE hMem = NULL;
	if (str != NULL) {
		// StringIuWFNg̓eRs[
		jint len = (*env)->GetStringLength(env, str);
		const _TCHAR* tmp = (*env)->GetStringChars(env, str, NULL);
		if ((*env)->ExceptionCheck(env)) {
			return;
		}

		// Windows CȄꍇANbv{[hƂ̃f[^]ɂLocalAllocgp
		// ܂AWindows CELocalAlloc()͕KAhXԂ
		hMem = LocalAlloc(0, sizeof(_TCHAR) * (len + 1));
		if (hMem == NULL) {
			(*env)->ReleaseStringChars(env, str, 0);
			throw_AWTError(env, "LocalAlloc() failed.");
			return;
		}
		_tcsncpy((_TCHAR*) hMem, tmp, len);
		(*env)->ReleaseStringChars(env, str, 0);
		((_TCHAR*) hMem)[len] = _T('\0');
	}

	// Nbv{[hI[v
	if (! OpenClipboard(NULL)) {
		// IllegalStateException  throw 
		jclass clazz = (*env)->FindClass(env, "java/lang/IllegalStateException");
		if (clazz) {
			(*env)->ThrowNew(env, clazz, "Faild to OpenClipBoard()");
		}
		
		// Jă^[
		LocalFree(hMem);
		return;
	}

	// Nbv{[h̓eɂAString̓eݒ肷
	if (! EmptyClipboard()) {
		// Nbv{[hɂłȂ
		throw_AWTError(env, "EmptyClipboard() failed");
	} else {
		if (hMem != NULL) {
			if (! SetClipboardData(CF_UNICODETEXT, hMem)) {
				// Nbv{[hɃf[^ݒłȂ
				throw_AWTError(env, "SetClipboardData() failed");
			}
		}
	}

	// Nbv{[h
	if (! CloseClipboard()) {
		throw_AWTError(env, "CloseClipboard() failed");
	}
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEClipboard
 * Method:    getNativeString
 * Signature: ()Ljava/awt/String;
 */
JNIEXPORT jstring JNICALL Java_gnu_java_awt_peer_wce_WCEClipboard_getNativeString(JNIEnv *env, jobject obj) {
	jstring result;

	// Nbv{[hI[v
	if (! OpenClipboard(NULL)) {
		// IllegalStateException  throw 
		jclass clazz = (*env)->FindClass(env, "java/lang/IllegalStateException");
		if (clazz) {
			(*env)->ThrowNew(env, clazz, "Faild to OpenClipBoard()");
		}
		return NULL;
	}
	if (IsClipboardFormatAvailable(CF_UNICODETEXT)) {
		// CF_UNICODETEXT i[ĂꍇA
		// ̃f[^擾 String IuWFNg𐶐
		HANDLE hMem = GetClipboardData(CF_UNICODETEXT);
		if (hMem == NULL) {
			result = NULL;
		} else {
			_TCHAR* tmp = (_TCHAR*) hMem;
			result = (*env)->NewString(env, tmp, _tcslen(tmp));
		}
	} else {
		result = NULL;
	}
	// Nbv{[h
	if (! CloseClipboard()) {
		throw_AWTError(env, "CloseClipboard() failed");
	}
	return result;
}