#include <windows.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEGraphicsConfiguration.h>

/*
 * Class:     gnu_java_awt_peer_wce_WCEGraphicsConfiguration
 * Method:    getBounds
 * Signature: ()Ljava/awt/Rectangle
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_WCEGraphicsConfiguration_getBounds(JNIEnv *env, jobject obj) {
	jobject result = NULL;
	jint width = (jint) GetSystemMetrics(SM_CXSCREEN);
	jint height = (jint) GetSystemMetrics(SM_CYSCREEN);
	jclass clazz = (*env)->FindClass(env, "java/awt/Rectangle");
	if (clazz) {
		jmethodID mid = (*env)->GetMethodID(env, clazz, "<init>", "(IIII)V");
		if (mid) {
			result = (*env)->NewObject(env,
									   clazz,
									   mid,
									   0,
									   0,
									   width,
									   height);
		}
	}
	return result;
}
