/* gnu_java_awt_peer_wce_WCEGraphicsEnvironment.c
   Copyright (C) 2005-2006 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <wingdi.h>
#include <jni.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCEGraphicsEnvironment.h>

#define MAX_FONTS	32

typedef struct allfonts_t {
	int num;
	_TCHAR names[MAX_FONTS][LF_FACESIZE];
} allfonts;

int CALLBACK EnumFontFamProc(const LOGFONT FAR* lpelf, const TEXTMETRIC FAR* lpntm, DWORD FontType, LPARAM lParam) {
	allfonts* fonts = (allfonts*) lParam;
	if (fonts->num >= MAX_FONTS) {
		return 0;
	}
	_tcscpy(fonts->names[fonts->num++], lpelf->lfFaceName);
	return fonts->num;
}

/*
 * Class:     gnu_java_awt_peer_wce_WCEGraphicsEnvironment
 * Method:    getNativeAvailableFontFamilyNames
 * Signature: ()[Ljava/lang/String;
 */
JNIEXPORT jobjectArray JNICALL Java_gnu_java_awt_peer_wce_WCEGraphicsEnvironment_getNativeAvailableFontFamilyNames(JNIEnv *env, jobject peer_obj) {
	HDC hDC = GetDC(NULL);
	allfonts fonts = {0};
	jobjectArray result = NULL;

	int num = EnumFontFamilies(hDC, NULL, EnumFontFamProc, (LPARAM) &fonts);
	ReleaseDC(NULL, hDC);

	result = (*env)->NewObjectArray(env, fonts.num, (*env)->FindClass(env, "java/lang/String"), NULL);
	if (result) {
		int i;
		for (i = 0; i < fonts.num; ++i) {
			jstring name = (*env)->NewString(env, fonts.names[i], _tcslen(fonts.names[i]));
			(*env)->SetObjectArrayElement(env, result, i, name);
			(*env)->DeleteLocalRef(env, name);
		}
	}
	return result;
}


/*
 * Class:     gnu_java_awt_peer_wce_WCEGraphicsEnvironment
 * Method:    getNativeMaximumWindowBounds
 * Signature: ()Ljava/awt/Rectangle;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_WCEGraphicsEnvironment_getNativeMaximumWindowBounds(JNIEnv *env, jobject peer_obj) {
	jobject result = NULL;
	RECT rect;
	jclass clazz;

	// [NGA𓾂
	SystemParametersInfo(SPI_GETWORKAREA, 0, &rect, 0);
	clazz = (*env)->FindClass(env, "java/awt/Rectangle");
	if (clazz) {
		jmethodID mid = (*env)->GetMethodID(env,
											clazz,
											"<init>",
											"(IIII)V");
		if (mid) {
			result = (*env)->NewObject(env,
									   clazz,
									   mid,
									   rect.left,
									   rect.top,
									   rect.right - rect.left,
									   rect.bottom - rect.top);
		}
	}
	return result;
}