/* gnu_java_awt_peer_wce_WCELabelPeer.c
   Copyright (C) 2005-2006 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <windows.h>
#include <jni.h>
#include <assert.h>
#include "wce-peer.h"
#include <gnu_java_awt_peer_wce_WCELabelPeer.h>

/**
 * Label̒萔
 */
#define Label_LEFT		0
#define Label_CENTER	1
#define Label_RIGHT		2

/*
 * Class:     gnu_java_awt_peer_wce_WCELabelPeer
 * Method:    createNative
 * Signature: (IIIII)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_WCELabelPeer_createNative(JNIEnv *env, jobject peer_obj, jint parentWindowHandle, jint x, jint y, jint width, jint height) {
	peer_obj = (*env)->NewGlobalRef(env, peer_obj);
	return (jint) create_native_label(peer_obj, (HWND) parentWindowHandle, x, y, width, height);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCELabelPeer
 * Method:    setNativeAlignment
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCELabelPeer_setNativeAlignment(JNIEnv *env, jobject peer_obj, jint windowHandle, jint alignment) {
	DWORD style;
	assert(windowHandle);
	style = GetWindowLong((HWND) windowHandle, GWL_STYLE);
	switch (alignment) {
	case Label_LEFT:
		style |= SS_LEFT;
		style &= ~SS_CENTER;
		style &= ~SS_RIGHT;
		break;
	case Label_CENTER:
		style &= ~SS_LEFT;
		style |= SS_CENTER;
		style &= ~SS_RIGHT;
		break;
	case Label_RIGHT:
		style &= ~SS_LEFT;
		style &= ~SS_CENTER;
		style |= SS_RIGHT;
		break;
	}
	SetWindowLong((HWND) windowHandle, GWL_STYLE, (LONG) style);
}

/*
 * Class:     gnu_java_awt_peer_wce_WCELabelPeer
 * Method:    getNativePreferredSize
 * Signature: (ILjava/lang/String;)Ljava/awt/Dimension;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_WCELabelPeer_getNativePreferredSize(JNIEnv *env, jobject peer_obj, jint windowHandle, jstring text) {
	jobject dim = NULL;
	SIZE size;
	int length;
	_TCHAR* buff;

	// x擾
	length = (int) SendMessage((HWND) windowHandle, WM_GETTEXTLENGTH, 0, 0);
	buff = (_TCHAR*) malloc(sizeof(_TCHAR) * (length + 1));
	if (buff) {
		jclass clazz;

		SendMessage((HWND) windowHandle, WM_GETTEXT, (WPARAM) length + 1, (LPARAM) buff);
		get_text_extent_point((HWND) windowHandle, buff, &size);
		free(buff);
		clazz = (*env)->FindClass(env, "java/awt/Dimension");
		if (clazz) {
			jmethodID constructor_id = (*env)->GetMethodID(env, clazz, "<init>", "(II)V");
			if (constructor_id) {
				dim = (*env)->NewObject(env,
										clazz,
										constructor_id,
										(jint) (size.cx * 1.1),
										(jint) (size.cy * 1.1));
			}
		}
	}
	return dim;
}
