/* gnu_java_awt_peer_wce_font_FreeTypeGlyphVector.cpp
   Copyright (C) 2008 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <gnu_java_awt_peer_wce_font_FreeTypeGlyphVector.h>
#include <ft2build.h>
#include FT_FREETYPE_H 
#include FT_OUTLINE_H 
#include FT_BITMAP_H
#include "FreeTypeFace.h"
#include "FreeTypeGlyphVector.h"

static jobject createShape(JNIEnv* env, FT_Vector* p1, FT_Vector* p2, FT_Vector* p3, FT_Vector* p4);

/*
 * Class:     gnu_java_awt_peer_wce_font_FreeTypeGlyphVector
 * Method:    createNative
 * Signature: (ILjava/awt/font/FontRenderContext;[CIII)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_font_FreeTypeGlyphVector_createNative
  (JNIEnv *env, jobject obj, jint nativeFacePointer, jobject frc, jcharArray text, jint start, jint limit, jint flags)
{
    FreeTypeFace* freeTypeFace = (FreeTypeFace*) nativeFacePointer;
    FT_Face face = freeTypeFace->getFace();
    const jint len = limit - start;
    jchar* tmp = (jchar*) ::malloc(sizeof(jchar) * (len + 1));
    if (! tmp)
    {
	return 0;
    }
    env->GetCharArrayRegion(text, start, (limit - start), tmp);
    tmp[len] = _T('\0');
    FreeTypeGlyphVector* v = new FreeTypeGlyphVector(face, (const _TCHAR*) tmp);
    free(tmp);

    return (jint) v;
}

/*
 * Class:     gnu_java_awt_peer_wce_font_FreeTypeGlyphVector
 * Method:    performNativeDefaultLayout
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_font_FreeTypeGlyphVector_performNativeDefaultLayout
  (JNIEnv *env, jobject obj, jint nativePointer, jint nativeFacePointer)
{
    FT_Face face = ((FreeTypeFace*) nativeFacePointer)->getFace();
    ((FreeTypeGlyphVector*) nativePointer)->performDefaultLayout(face);
}


/*
 * Class:     gnu_java_awt_peer_wce_font_FreeTypeGlyphVector
 * Method:    getNativeNumGlyphs
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_java_awt_peer_wce_font_FreeTypeGlyphVector_getNativeNumGlyphs
  (JNIEnv *env, jobject obj, jint nativePointer)
{
    return ((FreeTypeGlyphVector*) nativePointer)->getNumGlyphs();
}

/*
 * Class:     gnu_java_awt_peer_wce_font_FreeTypeGlyphVector
 * Method:    getNativeLogicalBounds
 * Signature: (I)Ljava/awt/geom/Rectangle2D;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_font_FreeTypeGlyphVector_getNativeLogicalBounds
  (JNIEnv *env, jobject obj, jint nativePointer)
{
    FT_Pos x, y, width, height;
    FreeTypeGlyphVector* gv = (FreeTypeGlyphVector*) nativePointer;
    gv->getLogicalBounds(&x, &y, &width, &height);

    jclass clazz = env->FindClass("java/awt/geom/Rectangle2D$Float");
    if (! clazz)
    {
	return NULL;
    }
    jmethodID mid = env->GetMethodID(clazz, "<init>", "(FFFF)V");
    if (! mid)
    {
	return NULL;
    }
    return env->NewObject(clazz, mid,
			  x/64.0,
			  0 - (y/64.0 + height/64.0), // Y̍W㉺]
			  width/64.0,
			  height/64.0);
}

/*
 * Class:     gnu_java_awt_peer_wce_font_FreeTypeGlyphVector
 * Method:    getNativeVisualBounds
 * Signature: (I)Ljava/awt/geom/Rectangle2D;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_font_FreeTypeGlyphVector_getNativeVisualBounds
  (JNIEnv *env, jobject obj, jint nativePointer)
{
    FT_Pos x, y, width, height;
    FreeTypeGlyphVector* gv = (FreeTypeGlyphVector*) nativePointer;
    gv->getVisualBounds(&x, &y, &width, &height);

    jclass clazz = env->FindClass("java/awt/geom/Rectangle2D$Float");
    if (! clazz)
    {
	return NULL;
    }
    jmethodID mid = env->GetMethodID(clazz, "<init>", "(FFFF)V");
    if (! mid)
    {
	return NULL;
    }
    return env->NewObject(clazz, mid,
			  x/64.0,
			  0 - (y/64.0 + height/64.0), // Y̍W㉺]
			  width/64.0,
			  height/64.0);
}

/*
 * Class:     gnu_java_awt_peer_wce_font_FreeTypeGlyphVector
 * Method:    getNativeGlyphPosition
 * Signature: (II[F)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_font_FreeTypeGlyphVector_getNativeGlyphPosition
  (JNIEnv *env, jobject obj, jint nativePointer, jint glyphIndex, jfloatArray position)
{
    FreeTypeGlyphVector* gv = (FreeTypeGlyphVector*) nativePointer;
    FT_Vector pos = gv->getGlyphPosition(glyphIndex);
    jfloat* dest = env->GetFloatArrayElements(position, NULL);
    dest[0] = pos.x / 64.0f;
    dest[1] = 0 - (pos.y / 64.0f);  // Y̍W㉺]
}


/*
 * Class:     gnu_java_awt_peer_wce_font_FreeTypeGlyphVector
 * Method:    setNativeGlyphPosition
 * Signature: (IIFF)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_font_FreeTypeGlyphVector_setNativeGlyphPosition
(JNIEnv *env, jobject obj, jint nativePointer, jint glyphIndex, jfloat x, jfloat y)
{
    FreeTypeGlyphVector* gv = (FreeTypeGlyphVector*) nativePointer;
    FT_Vector pos;
    pos.x = (FT_Pos) (x*64.0f);
    pos.y = (FT_Pos) (0.0f - (y*64.0f)); // Y̍W㉺]
    gv->setGlyphPosition(glyphIndex, pos);
}



static jobject createShape(JNIEnv* env, FT_Vector& p1, FT_Vector& p2, FT_Vector& p3, FT_Vector& p4)
{
    jclass clazz = env->FindClass("java/awt/geom/GeneralPath");
    if (! clazz)
    {
	return NULL;
    }
    jmethodID mid = env->GetMethodID(clazz, "<init>", "()V");
    if (! mid)
    {
	return NULL;
    }
    jobject result = env->NewObject(clazz, mid);
    if (! result)
    {
	return NULL;
    }
    mid = env->GetMethodID(clazz, "moveTo", "(FF)V");
    if (! mid)
    {
	return NULL;
    }
    env->CallVoidMethod(result, mid, p1.x/64.0f, 0.0f - p1.y/64.0f);

    mid = env->GetMethodID(clazz, "lineTo", "(FF)V");
    if (! mid)
    {
	return NULL;
    }
    env->CallVoidMethod(result, mid, p2.x/64.0f, 0.0f - p2.y/64.0f);
    env->CallVoidMethod(result, mid, p3.x/64.0f, 0.0f - p3.y/64.0f);
    env->CallVoidMethod(result, mid, p4.x/64.0f, 0.0f - p4.y/64.0f);

    mid = env->GetMethodID(clazz, "closePath", "()V");
    if (! mid)
    {
	return NULL;
    }
    env->CallVoidMethod(result, mid);
    
    return result;
}

/*
 * Class:     gnu_java_awt_peer_wce_font_FreeTypeGlyphVector
 * Method:    getNativeGlyphLogicalBounds
 * Signature: (II)Ljava/awt/Shape;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_font_FreeTypeGlyphVector_getNativeGlyphLogicalBounds
  (JNIEnv *env, jobject obj, jint nativePointer, jint glyphIndex)
{
    FreeTypeGlyphVector* gv = (FreeTypeGlyphVector*) nativePointer;
    FT_Vector p1, p2, p3, p4;
    gv->getGlyphLogicalBounds(glyphIndex, &p1, &p2, &p3, &p4);
    return createShape(env, p1, p2, p3, p4);
}

/*
 * Class:     gnu_java_awt_peer_wce_font_FreeTypeGlyphVector
 * Method:    getNativeGlyphVisualBounds
 * Signature: (II)Ljava/awt/Shape;
 */
JNIEXPORT jobject JNICALL Java_gnu_java_awt_peer_wce_font_FreeTypeGlyphVector_getNativeGlyphVisualBounds
  (JNIEnv *env, jobject obj, jint nativePointer, jint glyphIndex)
{
    FreeTypeGlyphVector* gv = (FreeTypeGlyphVector*) nativePointer;
    FT_Vector p1, p2, p3, p4;
    gv->getGlyphVisualBounds(glyphIndex, &p1, &p2, &p3, &p4);
    return createShape(env, p1, p2, p3, p4);
}

/*
 * Class:     gnu_java_awt_peer_wce_font_FreeTypeGlyphVector
 * Method:    disposeNative
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_font_FreeTypeGlyphVector_disposeNative
  (JNIEnv *env, jobject obj, jint nativePointer)
{
    FreeTypeGlyphVector* gv = (FreeTypeGlyphVector*) nativePointer;
    delete gv;
}

