#include <com_mysaifu_jvm_java_security_provider_SystemKeyStoreSpi.h>
#include "wcesecurity.h"
#include "KeyStore.h"

/*
 * Class:     com_mysaifu_jvm_java_security_provider_SystemKeyStoreSpi
 * Method:    openNativeCertStore
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_com_mysaifu_jvm_java_security_provider_SystemKeyStoreSpi_openNativeCertStore
  (JNIEnv *env, jobject, jstring storeName)
{
  _TCHAR* name = ::getString(env, storeName);
  HCERTSTORE hCert = ::CertOpenSystemStore(NULL, name);
  free(name);

  return reinterpret_cast<jint>(new KeyStore(hCert));
}

/*
 * Class:     com_mysaifu_jvm_java_security_provider_SystemKeyStoreSpi
 * Method:    closeNativeCertStore
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_com_mysaifu_jvm_java_security_provider_SystemKeyStoreSpi_closeNativeCertStore
  (JNIEnv *, jobject, jint nativePointer)
{
  if (! nativePointer)
  {
    return;
  }

  KeyStore* pKeyStore = reinterpret_cast<KeyStore*>(nativePointer);
  delete pKeyStore;
}

