/* WCESelectionKey.java -- 
   Copyright (C) 2010 Mysaifu.com

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package com.mysaifu.jvm.java.nio.channels;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.AbstractSelectableChannel;
import gnu.java.nio.VMChannel;

public class WCESelectionKey
    extends AbstractSelectionKey
{
  int interestOps;

  int readyOps;

  private final WCESelector selector;

  private final AbstractSelectableChannel channel;

  WCESelectionKey(WCESelector selector, AbstractSelectableChannel channel)
  {
    this.channel = channel;
    this.selector = selector;
  }

  @Override
  public SelectableChannel channel()
  {
    return channel;
  }

  @Override
  public int interestOps()
  {
    return interestOps;
  }

  @Override
  public SelectionKey interestOps(int ops)
  {
    if (! isValid())
      throw new IllegalStateException("key is invalid");
    if ((ops & ~ channel.validOps()) != 0)
      throw new IllegalArgumentException(
                                         "channel does not support all operations");
    this.interestOps = ops;
    return this;
  }

  @Override
  public int readyOps()
  {
    return readyOps;
  }

  /**
   * s\ȑݒ肷
   */
  void readyOps(int readyOps)
  {
    this.readyOps = readyOps;
  }

  @Override
  public Selector selector()
  {
    return selector;
  }

  public String toString()
  {
    return super.toString();
  }

  int getNativeFD() throws IOException
  {
    VMChannel vmchannel = null;
    if (this.channel instanceof WCESocketChannel)
      {
        vmchannel = ((WCESocketChannel) this.channel).getVMChannel();
      }
    else if (this.channel instanceof WCEServerSocketChannel)
      {
        vmchannel = ((WCEServerSocketChannel) this.channel).getVMChannel();
      }
    if (vmchannel == null)
      {
        return 0;
      }

    return vmchannel.getState().getNativeFD();
  }
}
