/* PFXKeyStoreSpi.java -- 
   Copyright (C) 2009 Mysaifu.com

This file is a part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301
USA

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package com.mysaifu.jvm.java.security.provider;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PFXKeyStoreSpi
    extends WCEKeyStoreSpi
{
  private static class ShutdownHook
      implements Runnable
  {
    private final List<WeakReference<PFXKeyStoreSpi>> storeList = new ArrayList<WeakReference<PFXKeyStoreSpi>>();
    
    public void add(PFXKeyStoreSpi store)
    {
      storeList.add(new WeakReference(store));
    }
    
    public void run()
    {
      for (WeakReference<PFXKeyStoreSpi> ref : storeList)
        {
          PFXKeyStoreSpi store = ref.get();
          if (store != null)
            {
              try
              {
                store.close();
              }
              catch (CertificateException ce)
              {
                ce.printStackTrace();
              }
            }
        }
    }
  }
  
  private static final ShutdownHook shutdownHook;
  private static final Thread shutdownHookThread;

  static
  {
    // 閧폜Kv̂ŁAVbg_EtbNݒ肷
    shutdownHook = new ShutdownHook();
    shutdownHookThread = new Thread(shutdownHook, "PFXKeyStoreSpi shutdown hook thread");
    Runtime.getRuntime().addShutdownHook(shutdownHookThread);
  }
  
  public PFXKeyStoreSpi()
  {
    shutdownHook.add(this);
  }

  /**
   * w肳ꂽInputStreamƃpX[hgāAؖXgAI[vB
   * 
   * @param ins ̓f[^Bnull̏ꍇB
   * @param password pX[hBnull̏ꍇB
   * @return HCERTSTORE
   */
  protected int openCertStore(InputStream ins, char[] password)
      throws IOException, NoSuchAlgorithmException, CertificateException
  {
    byte[] buff = new byte[4096];
    int len;
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    while ((len = ins.read(buff)) != - 1)
      {
        baos.write(buff, 0, len);
      }
    baos.close();

    byte[] data = baos.toByteArray();

    return openNativeCertStore(data, password);
  }

  /**
   * lCeBuؖXgAI[v
   */
  private native int openNativeCertStore(byte[] data, char[] password)
      throws CertificateException;

  /**
   * ؖXgAN[Y
   */
  protected void closeCertStore(int nativePointer) throws CertificateException
  {
    closeNativeCertStore(nativePointer);
  }

  private native void closeNativeCertStore(int nativePointer)
      throws CertificateException;
}
