/* SystemKeyStoreSpi.java --- Windows CE system KeyStoreSpi.
   Copyright (C) 2009 Mysaifu.com

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package com.mysaifu.jvm.java.security.provider;

import java.io.InputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public abstract class SystemKeyStoreSpi extends WCEKeyStoreSpi
{
  private final String storeName;
  
  protected SystemKeyStoreSpi(String name)
  {
    this.storeName = name;
    if (name == null)
      {
        throw new IllegalArgumentException("name==null");
      }
  }
  
  /**
   * w肳ꂽInputStreamƃpX[hgāAؖXgAI[vB
   * 
   * @param ins ̓f[^Bnull̏ꍇB
   * @param password pX[hBnull̏ꍇB
   * @return HCERTSTORE
   */
  @Override
  protected int openCertStore(InputStream ins, char[] password)
      throws IOException, NoSuchAlgorithmException, CertificateException
  {
    // InputStreampassword͎gpȂ
    return openNativeCertStore(this.storeName);
  }
  
  private native int openNativeCertStore(String storeName);
 
  /**
   * ؖXgAN[Y
   * 
   * @throws KeyStoreException N[YɎsꍇ
   */
  protected void closeCertStore(int nativePointer)
      throws CertificateException
      {
        closeNativeCertStore(nativePointer);
      }
  
  private native void closeNativeCertStore(int nativePointer);
}