/* WCESSLContextSpi.java -- 
   Copyright (C) 2009 Mysaifu.com

This file is a part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301
USA

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package com.mysaifu.jvm.java.security.provider;

import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;

import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;

public final class WCESSLContextSpi
    extends SSLContextSpi
{
  /**
   * }l[W
   */
  private X509ExtendedKeyManager keyManager;

  /**
   * M}l[WB
   */
  private X509TrustManager trustManager;

  /**
   * SecureRandom
   */
  private SecureRandom secureRandom;

  public WCESSLContextSpi()
  {
  }

  @Override
  protected SSLEngine engineCreateSSLEngine()
  {
    return engineCreateSSLEngine(null, - 1);
  }

  @Override
  protected SSLEngine engineCreateSSLEngine(String host, int port)
  {
    return new WCESSLEngine(this, null, host, port);
  }

  @Override
  protected synchronized SSLSessionContext engineGetClientSessionContext()
  {
    throw new UnsupportedOperationException("Not supported");
  }

  @Override
  protected synchronized SSLSessionContext engineGetServerSessionContext()
  {
    throw new UnsupportedOperationException("Not supported");
  }

  @Override
  protected SSLServerSocketFactory engineGetServerSocketFactory()
  {
    return new WCESSLServerSocketFactory(this);
  }

  @Override
  protected SSLSocketFactory engineGetSocketFactory()
  {
    return new WCESSLSocketFactory(this);
  }

  @Override
  protected void engineInit(KeyManager[] keyManagers,
                            TrustManager[] trustManagers, SecureRandom random)
      throws KeyManagementException
  {
    if (keyManagers != null && keyManagers.length > 0)
      {
        for (int i = 0; i < keyManagers.length; ++i)
          {
            if (keyManagers[i] instanceof X509ExtendedKeyManager)
              this.keyManager = (X509ExtendedKeyManager) keyManagers[i];
            break;
          }
      }
    if (this.keyManager == null)
      {
        try
          {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(
                                                                  WCESecurity.KEY_MANAGER_FACTORY_TYPE,
                                                                  WCESecurity.NAME);
            kmf.init(null, null);
            this.keyManager = (X509ExtendedKeyManager) kmf.getKeyManagers()[0];
          }
        catch (NoSuchAlgorithmException nsae)
          {
            throw new KeyManagementException(nsae);
          }
        catch (NoSuchProviderException nspe)
          {
            throw new KeyManagementException(nspe);
          }
        catch (KeyStoreException ke)
          {
            throw new KeyManagementException(ke);
          }
        catch (UnrecoverableKeyException uke)
          {
            throw new KeyManagementException(uke);
          }
        catch (IllegalStateException ise)
          {
            throw new KeyManagementException(ise);
          }
      }

    if (trustManagers != null && trustManagers.length > 0)
      {
        TrustManager tm = trustManagers[0];
        if (tm instanceof X509TrustManager)
          {
            this.trustManager = (X509TrustManager) tm;
          }
      }
    if (this.trustManager == null)
      {
        this.trustManager = WCETrustManagerFactorySpi.getDefaultTrustManager();
      }

    // SecureRandom͎gpȂAꉞێĂ
    this.secureRandom = random;
  }

  /**
   * KeyManagerԂ
   */
  X509ExtendedKeyManager getKeyManager()
  {
    return this.keyManager;
  }

  /**
   * TrustManagerԂB
   */
  X509TrustManager getTrustManager()
  {
    return this.trustManager;
  }
}
