/* WCESecurity.java --- Windows CE security provider.
   Copyright (C) 2009 Mysaifu.com

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package com.mysaifu.jvm.java.security.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;

/**
 * Security provider for Windows CE device.
 */
public final class WCESecurity
    extends Provider
{
  static final String NAME = "WCESecurity";
  
  static final String ROOT_KEY_STORE_TYPE = "WindowsCE-ROOT";

  static final String DEFAULT_SECURE_RANDOM_ALGOLITHM = "WindowsCE-PRNG";

  static final String KEY_MANAGER_FACTORY_TYPE = "MysaifuX509";
  static final String TRUST_MANAGER_FACTORY_TYPE = "MysaifuX509";
  
  public WCESecurity()
  {
    super(NAME, 0.01, "Windows CE security provider v0.0.1");
    AccessController.doPrivileged(new PrivilegedAction()
    {
      public Object run()
      {
        // SSLContext
        put("SSLContext.TLSv1", WCESSLContextSpi.class.getName());
        put("Alg.Alias.SSLContext.SSLv3", "TLSv1");
        put("Alg.Alias.SSLContext.TLSv1.0", "TLSv1");
        put("Alg.Alias.SSLContext.TLS", "TLSv1");
        put("Alg.Alias.SSLContext.SSL", "TLSv1");

        // KeyStore
        put("KeyStore." + ROOT_KEY_STORE_TYPE,
            "com.mysaifu.jvm.java.security.provider.ROOTKeyStoreSpi");
        put("KeyStore.WindowsCE-MY",
            "com.mysaifu.jvm.java.security.provider.MYKeyStoreSpi");

        // KeyStore for Windows PFX format (is a predecessor to PKCS #12)
        put("KeyStore.WindowsCE-PFX",
            "com.mysaifu.jvm.java.security.provider.PFXKeyStoreSpi");
        put("Alg.Alias.KeyStore.PFXKeyStoreSpi", "WindowsCE-PFX");

        put("Alg.Alias.KeyStore.PKCS12", "WindowsCE-PFX");
        put("Alg.Alias.KeyStore.JKS", "WindowsCE-PFX"); // for testing

        // KeyManagerFactorySpi
        put("KeyManagerFactory." + KEY_MANAGER_FACTORY_TYPE,
            "com.mysaifu.jvm.java.security.provider.WCEKeyManagerFactorySpi");

        // TrustManagerFactorySpi
        put("TrustManagerFactory." + TRUST_MANAGER_FACTORY_TYPE,
            "com.mysaifu.jvm.java.security.provider.WCETrustManagerFactorySpi");

        // SecureRandom
        put("SecureRandom." + DEFAULT_SECURE_RANDOM_ALGOLITHM,
            "com.mysaifu.jvm.java.security.provider.WCESecureRandomSpi");

        return null;
      }
    });
  }

  static void loadLibraries()
  {
    AccessController.doPrivileged(new PrivilegedAction<Void>()
    {
      public Void run()
      {
        // lCeBuCu[h
        System.loadLibrary("wcesecurity");
        return null;
      }
    });
  }
}
