/* WCECompatibleImage.java
   Copyright (C) 2006 Free Software Foundation, Inc.

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

/**
 * BufferedImageƌ݊̂ImageB
 * BufferedImageƃlCeBuC[WԂ̃sNZf[^]ǗB
 * ̃CX^Xɑ΂`挋ʂ́AupdateBufferedImage(int, int, int, int)\bhĂяoƂ
 * BufferedImageɔf邱ƂłB
 *
 */
public class WCECompatibleImage extends WCEImage {
	/**
	 * WCECompatibleImageƑΉBufferedImageێMapB
	 * BufferedImage ̃CX^XL[ɂāAWCEDIBSectionImagẽCX^XĂB
	 */
	static Map bufferedImages = new HashMap();

	/**
	 * ֘AtꂽBufferedImageB
	 */
	private final BufferedImage image;

	/**
	 * w肳ꂽBufferedImageƌ݊̂CX^X쐬B
	 */
	protected WCECompatibleImage(BufferedImage image) {
		this.image = image;
		setDimension(image.getWidth(), image.getHeight());
		
		// C[Wf[^BufferedImage̓eŏ
		load();
	}
	
	/**
	 * w肳ꂽBufferedImageƌ݊̂CX^X쐬B
	 * LbV𒲂ׁAłɑΉWCECompatibleImagẽCX^XĂꍇ́A
	 * ̃CX^XԂB
	 */
	public static WCECompatibleImage getInstance(BufferedImage image) {
		synchronized (bufferedImages) {
			Object instance = bufferedImages.get(image);
			if (instance != null) {
				return (WCECompatibleImage) instance;
			}
			// VKɃCX^X쐬
			WCECompatibleImage result = new WCECompatibleImage(image);
			bufferedImages.put(image, result);
			return result;
		}
	}
	
	protected int createBitmapHandle(int windowHandle) {
		// ToDo: œKȃtH[}bglCeBuC[W쐬
		return createNativeBitmapHandle(getWidth(), getHeight());
	}
	
	/**
	 * lCeBurbg}bv쐬Ãnh(HBITMAP)ԂB
	 */
	private native int createNativeBitmapHandle(int width, int height);

	/**
	 * ̃CX^XɊ֘Atꂽ BufferedImage ԂB
	 * ԂꂽBufferedImagẽsNZ𒼐ڑ삵ꍇ́A
	 * load() Ăяoēeč\zKv
	 */
	public BufferedImage getBufferedImage() {
		return this.image;
	}

	/**
	 * ֘AtꂽBufferedImageɓe]
	 *
	 * @param	x	]͈͍xW
	 * @param	y	]͈͍yW
	 * @param	width	]͈͂̕
	 * @param	height	]͈͂̍
	 */
	public void updateBufferedImage(int x, int y, int width, int height) {
		// ToDo: 
		BufferedImage image = getBufferedImage();
		int[] pixels = image.getRGB(0,
									0,
									getWidth(),
									getHeight(),
									null,
									0,
									getWidth());
		setNativeData(getBitmapHandle(), pixels);
	}
	
	/**
	 * w肳ꂽsNZf[^̓elCeBuf[^ɐݒ肷B
	 */
	private native void setNativeData(int bitmapHandle, int[] pixels);
	
	/**
	 * ֘AtꂽBufferedImageŜ̓e[h
	 */
	public void load() {
		// ݂̎ł́ATCYύXĂ܂ƑΉłȂ
		if (getWidth() != this.image.getWidth()
				|| getHeight() != this.image.getHeight()) {
			throw new IllegalStateException("Image size changed");
		}
		
		int[] pixels = getNativeData(getBitmapHandle());
		BufferedImage image = getBufferedImage();
		image.setRGB(0,
					 0,
					 getWidth(),
					 getHeight(),
					 pixels,
					 0,
					 getWidth());
	}

	/**
	 * lCeBuf[^int[]zƂĎ擾
	 * Ԃꂽ int z̃f[^tH[}bg͈ȉ̂悤ɂȂB
	 *
	 * 00RRGGBB
	 */
	private native int[] getNativeData(int bitmapHandle);

}
