/* WCEContainerPeer.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package gnu.java.awt.peer.wce;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;

public class WCEContainerPeer
    extends WCEComponentPeer
    implements ContainerPeer
{
  public WCEContainerPeer(Container c)
  {
    super(c);
  }

  protected native int createNative(int hParentWnd, int x, int y, int width,
                                    int height);

  public Insets insets()
  {
    return getInsets();
  }

  public Insets getInsets()
  {
    return getNativeInsets(getWindowHandle());
  }

  /**
   * lCeBuR|[lgInsetsԂ
   */
  native Insets getNativeInsets(int windowHandle);

  public void beginValidate()
  {
  }

  public void endValidate()
  {
  }

  public void beginLayout()
  {
  }

  public void endLayout()
  {
  }

  public boolean isPaintPending()
  {
    return false;
  }

  public Graphics getGraphics()
  {
    Graphics g = super.getGraphics();
    // _킹
    Insets i = getInsets();
    g.translate(- i.left, - i.top);
    return g;
  }

  /**
   * PaintEventpost
   */
  void postPaintEvent(int id, int x, int y, int width, int height)
  {
    // InsetsW炷
    // ToDo:̕@͌̂ŁAlCeBuōs
    Insets i = getInsets();
    x += i.left;
    y += i.top;
    super.postPaintEvent(id, x, y, width, height);
  }

  void postMouseEvent(int id, int modifiers, int x, int y, int clickCount,
                      boolean popupTrigger, int button)
  {
    // Insets̕W𒲐
    // ToDo:̕@͌̂ŁAlCeBuōs
    Insets i = getInsets();
    x += i.left;
    y += i.top;
    super.postMouseEvent(id, modifiers, x, y, clickCount, popupTrigger, button);
  }

  public boolean isRestackSupported()
  {
    // FIXME: implement
    return false;
  }

  public void cancelPendingPaint(int x, int y, int width, int height)
  {
    // FIXME: implement
  }

  public void restack()
  {
    // FIXME: implement
  }

}
