/* WCEGraphicsConfiguration.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.GraphicsDevice;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.Transparency;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;

/**
 * RtBO[V
 */
public class WCEGraphicsConfiguration extends GraphicsConfiguration
{
  /**
   * ΉfoCX
   */
  private final GraphicsDevice device;
	
  WCEGraphicsConfiguration(GraphicsDevice device)
  {
    this.device = device;
  }
	
  public GraphicsDevice getDevice()
  {
    return this.device;
  }
	
  public BufferedImage createCompatibleImage(int w, int h)
  {
    return new BufferedImage(w, h, BufferedImage.TYPE_USHORT_565_RGB);
  }
	
  public VolatileImage createCompatibleVolatileImage(int w, int h)
  {
    return null;
  }
	
  public BufferedImage createCompatibleImage(int w, int h, int transparency)
  {
    switch (transparency)
    {
      case Transparency.OPAQUE:
        return createCompatibleImage(w, h);

      case Transparency.BITMASK:
      case Transparency.TRANSLUCENT:
        return new BufferedImage(w, h, BufferedImage.TYPE_INT_ARGB);

      default:
        throw new IllegalArgumentException("transparency=" + transparency);
    }
  }
	
  public ColorModel getColorModel()
  {
    return new DirectColorModel(16,
                                0xf800,   // 5
                                0x07e0,   // 6
                                0x001f);  // 5

  }
	
  public ColorModel getColorModel(int transparency)
  {
    return ColorModel.getRGBdefault();
  }
	
  public AffineTransform getDefaultTransform()
  {
    return new AffineTransform();
  }
	
  public AffineTransform getNormalizingTransform()
  {
    return new AffineTransform();
  }
	
  public native Rectangle getBounds();

  public VolatileImage createCompatibleVolatileImage(int width, int height, int transparency)
  {
      // FIXME: implement
    return null;
  }

}
