/* WCEImageProducer.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.HashSet;
import java.util.Set;

/**
 * WCEImageɑΉImageProducer
 */
public class WCEImageProducer implements ImageProducer {
	static {
		initIDs();
	}
	
	/**
	 * f[^񋟌ƂȂWCEImage
	 */
	private final WCEImage image;
	
	/**
	 * ImageConsumer
	 */
	private final Set consumerSet = new HashSet();
	
	/**
	 * w肳ꂽC[W̃f[^񋟂ImageProducer쐬
	 */
	public WCEImageProducer(WCEImage image) {
		this.image = image;
	}
	
	private native static void initIDs();
	
	/**
	 * f[^񋟂ƂWCEImageԂB
	 */
	public WCEImage getImage() {
		return this.image;
	}
	
	public void addConsumer(ImageConsumer ic) {
		this.consumerSet.add(ic);
	}
	
	public boolean isConsumer(ImageConsumer ic) {
		return this.consumerSet.contains(ic);
	}
	
	public void removeConsumer(ImageConsumer ic) {
		this.consumerSet.remove(ic);
	}
	
	public void startProduction(ImageConsumer ic) {
		try {
			// C[Ŵ҂
			MediaTracker tracker = new MediaTracker(new Component() {});
			tracker.addImage(this.image, 0);
			tracker.waitForID(0);
			if (tracker.isErrorAny()) {
				// G[ꍇImageConsumerɃG[ʒmA^[
				ImageConsumer[] c = (ImageConsumer[]) this.consumerSet.toArray(new ImageConsumer[0]);
				for (int i = 0; i < c.length; ++i) {
					c[i].imageComplete(ImageConsumer.IMAGEERROR | ImageConsumer.IMAGEABORTED);
				}
				return;
			}
			// C[W𐶐
			addConsumer(ic);
			ImageConsumer[] c = (ImageConsumer[]) this.consumerSet.toArray(new ImageConsumer[0]);
			
			startNativeProduction(this.image.getWindowHandle(),
								  this.image.getBitmapHandle(),
								  c);
			
		} catch (InterruptedException ie) {
			ie.printStackTrace();
		}
	}
	
	private native void startNativeProduction(int windowHandle, int bitmapHandle, ImageConsumer[] c);
	
	public void requestTopDownLeftRightResend(ImageConsumer ic) {
		startProduction(ic);
	}
}
