/* FreeTypeFace.java - 
   Copyright (C) 2008 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce.font;

import java.awt.FontFormatException;
import java.io.File;
import java.io.InputStream;
import java.io.IOException;

/**
 * FreeTypeFace.
 */
public class FreeTypeFace
{
  static
  {
    try
    {
      // initialize FreeType native library.
      initNative();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  public static final int LEADING_INDEX = 0;
  public static final int ASCENT_INDEX = 1;
  public static final int DESCENT_INDEX = 2;
  public static final int MAXASCENT_INDEX = 3;
  public static final int MAXDESCENT_INDEX = 4;
  public static final int MAXADVANCE_INDEX = 5;

  private final int nativePointer;
  private final File file;

  /**
   * Creates a new FreeTypeFace object from specified file.
   * 
   * @param file  source data file.
   */
  public FreeTypeFace(File file) throws FontFormatException, IOException
  {
    this.nativePointer = createNativeFromFile(file.getAbsolutePath());
    this.file = file;
  }

  /**
   * creates a new FreeTypeFace object from specified buffer.
   * 
   * @param in  InputStream.
   */
  public FreeTypeFace(InputStream in) throws FontFormatException, IOException
  {
    this.nativePointer = createNativeFromStream(in);
    this.file = null;
  }

  private native int createNativeFromFile(String fileName) throws FontFormatException, IOException;
  private native int createNativeFromStream(InputStream in) throws FontFormatException, IOException;

  private static native void initNative();

  public File getFile()
  {
    return this.file;
  }

  public String getFamilyName()
  {
    return getNativeFamilyName(this.nativePointer);
  }

  private native String getNativeFamilyName(int nativePointer);

  public void setCharSize(float size) throws FreeTypeException
  {
    setNativeCharSize(this.nativePointer, size);
  }

  private native void setNativeCharSize(int nativePointer, float size);

  public float[] getFontMetrics(float size)
  {
    return getNativeFontMetrics(this.nativePointer, size);
  }

  private native float[] getNativeFontMetrics(int nativePointer, float size);

  public float getCharsWidth(float size, char[] text, int offset, int length)
  {
    return getNativeCharsWidth(this.nativePointer, size, text, offset, length);
  }

  private native float getNativeCharsWidth(int nativePointer, float size, char[] text, int offset, int length);

  int getNativePointer()
  {
    return this.nativePointer;
  }

  protected void finalize()
  {
    disposeNative(this.nativePointer);
  }

  private native void disposeNative(int nativePointer);
}
