/* FreeTypeGlyphPathIterator.java
   Copyright (C) 2008 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce.font;

import java.awt.geom.PathIterator;

public class FreeTypeGlyphPathIterator implements PathIterator
{
    private final FreeTypeGlyphVector glyphVector;
    private final int nativePointer;

    public FreeTypeGlyphPathIterator(FreeTypeGlyphVector gv)
    {
	this.glyphVector = gv;
	this.nativePointer = createNative(gv.getNativePointer());
    }

    public FreeTypeGlyphPathIterator(FreeTypeGlyphVector gv, int glyphIndex)
    {
	this.glyphVector = gv;
	this.nativePointer = createNative(gv.getNativePointer(), glyphIndex);
    }

    private native int createNative(int glyphVectorNativePointer);
    private native int createNative(int glyphVectorNativePointer, int glyphIndex);

    public boolean isDone()
    {
	return isNativeDone(this.nativePointer);
    }

    private native boolean isNativeDone(int nativePointer);

    public void next()
    {
	nextNative(this.nativePointer);
    }

    private native void nextNative(int nativePointer);

    public int currentSegment(float[] coords)
    {
	return currentNativeSegment(this.nativePointer, coords);
    }

    private native int currentNativeSegment(int nativePointer, float[] coords);

    public int currentSegment(double[] coords)
    {
	float[] tmp = new float[coords.length];
	int ret = currentSegment(tmp);
	for (int i = 0; i < coords.length; ++i)
	{
	    coords[i] = tmp[i];
	}
	return ret;
    }

    public int getWindingRule()
    {
	return WIND_NON_ZERO;
    }

    protected void finalize()
    {
	disposeNative(this.nativePointer);
    }

    private native void disposeNative(int nativePointer);
}
