/* WCEFontMetrics.java
   Copyright (C) 2005, 2006  Free Software Foundation, Inc.

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package gnu.java.awt.peer.wce.font;

import gnu.java.awt.ClasspathToolkit;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public class WCEFontMetrics extends FontMetrics {
	private int[] metrics;
	private WCEFontPeer peer;

	static final int FONT_METRICS_ASCENT		= 0;
	static final int FONT_METRICS_DESCENT		= 1;
	static final int FONT_METRICS_MAX_ADVANCE	= 2;

	public WCEFontMetrics (Font font) {
		super(initFont(font));
		this.peer = (WCEFontPeer) this.font.getPeer();

		this.metrics = new int[3];
		
		loadNativeFontMetrics(this.peer.getFontHandle(), this.metrics);
	}
	
	/**
	 * Makes sure to return a Font based on the given Font that has as
	 * peer a WCEFontPeer. Used in the initializer.
	 */
	private static Font initFont(Font font) {
		if (font == null)
			return new Font("Dialog", Font.PLAIN, 12);
		else if (font.getPeer() instanceof WCEFontPeer)
			return font;
		else {
			ClasspathToolkit toolkit;
			toolkit = (ClasspathToolkit) Toolkit.getDefaultToolkit();
			return toolkit.getFont(font.getName(), font.getAttributes());
		}
	}
  	
  	private native void loadNativeFontMetrics(int fontHandle, int[] metrics);
  	
	public int stringWidth (String str) {
		return getNativeStringWidth(this.peer.getFontHandle(), str);
	}
	
	private native int getNativeStringWidth(int fontHandle, String str);

	public int charWidth (char ch) {
		return stringWidth(new String (new char[] { ch }));
	}

	public int charsWidth (char data[], int off, int len) {
		return stringWidth (new String (data, off, len));
	}

	public int getLeading () {
		return 1;
//      return metrics[ASCENT] + metrics[DESCENT];
	}

	public int getAscent() {
		return this.metrics[FONT_METRICS_ASCENT];
	}

	public int getDescent() {
		return this.metrics[FONT_METRICS_DESCENT];
	}

	public int getMaxAdvance () {
    	return this.metrics[FONT_METRICS_MAX_ADVANCE];
	}
}
