/*
 * xalloc.h     publicized macros of memory.c V.2.1 or later
 *  1997/03     kmatsui
 */

#if     _MEM_DEBUG
/*
 * The following macros should be renamed for the user program which calls
 *      malloc() or others through user functions named, for example,
 *      xmalloc() or so.  Of course, adjust arguments, if necessary.
 *      And surround the function name in its declaration or definition to
 *      avoid macro expansion.
 * For example:
 *  ** macro definition **  (as the following definitions)
 *  #define xmalloc( size)  \
 *          (_memline = __LINE__, _memfile = __FILE__, xmalloc( size))
 *  ** function declaration **
 *  void    *(xmalloc)( size_t size);
 *  ** function definition  **
 *  void    *(xmalloc)( size_t size) {
 *      ...;
 *  }
 * This macro informs malloc() from where it is called in effect.
 */
#if     XMALLOC
#define xmalloc( size)   \
            (_memline = __LINE__, _memfile = __FILE__, xmalloc( size))
#define xrealloc( ptr, size) \
            (_memline = __LINE__, _memfile = __FILE__, xrealloc( ptr, size))
#define xcalloc( num, size)  \
            (_memline = __LINE__, _memfile = __FILE__, xcalloc( num, size))
#define free( ptr)      \
            (_memline = __LINE__, _memfile = __FILE__, free( ptr))
#else
#define malloc( size)   \
            (_memline = __LINE__, _memfile = __FILE__, malloc( size))
#define realloc( ptr, size) \
            (_memline = __LINE__, _memfile = __FILE__, realloc( ptr, size))
#define calloc( num, size)  \
            (_memline = __LINE__, _memfile = __FILE__, calloc( num, size))
#define free( ptr)      \
            (_memline = __LINE__, _memfile = __FILE__, free( ptr))
#endif
#endif

/*
 * Macros to represent the value of 'memcheck' (default:0).
 * OR'ed values of these can be used.
 * Check of pointer to free(), free-blocks-list, written-free-block and
 *      written-trailing-area are always done, whatever value `memcheck' may
 *      has.
 * MERR_LIST implies the function of MERR_CHKALL too.
 * MERR_CHKALL and MERR_LIST are enabled if and only _MEM_DEBUG is true.
 *      _MEM_DEBUG links list_heap() to do this.
 */
#define MERR_FIRSTFIT   1           /* do first-fit (default:best-fit)      */
#define MERR_CHKALL     2           /* do all the error checking    */
#define MERR_LIST       4           /* list and check all blocks    */

extern int  memcheck;               /* mode of error checking       */
extern void (*merrfunc)( int);  /* function executed on error (default:exit)*/
/* extern void (*merrfunc)();   */          /* for the old compilers        */

/* the calling count when memcheck is to be set to MERR_LIST.
 * Enabled only on _MEM_DEBUG version.
 */
extern unsigned memlist;

#if     _MEM_DEBUG
extern unsigned _memcount;      /* the number of calls to malloc(), etc.    */
extern int      _memline;       /* __LINE__ from where malloc() is called   */
extern char     *_memfile;      /* __FILE__ from where malloc() is called   */
#endif

#ifdef _WIN32_WCE
#define	EFREEP		2120
#define EFREEBLK	2121
#define EALLOCBLK	2122
#define EFREEWRT	2123
#define ETRAILWRT	2124

#define EXCEPTION_IN_KMMALLOC	1

#endif