/*
 *  TOPPERS/OSEK Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      OSEK Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2004 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	^XNǗW[
 */

#ifndef _TASK_H_
#define _TASK_H_

/*
 *  ^XNID̓Ȓl̒`
 */
#define TSKID_NULL		((TaskType) UINT8_INVALID)	/* ID */

/*
 *  ^XNԁitcb_statjl̒`
 */
#define TS_RUNNABLE		READY				/* sԁCs\ */
#define TS_DORMANT		SUSPENDED			/* x~ */
#define TS_WAITING		WAITING				/* ҂ */

/*
 *  ^XNێϐ̐錾ikernel_cfg.cj
 */
extern const UINT8	tnum_task;		/* ^XN̐ */
extern const UINT8	tnum_exttask;		/* g^XN̐ */

/*
 *  ^XNubNikernel_cfg.cj
 */
extern const Priority	tinib_inipri[];		/* Dx */
extern const Priority	tinib_exepri[];		/* sJn̗Dx */
extern const UINT8		tinib_maxact[];		/* dNv̍ő吔 */
extern const AppModeType tinib_autoact[];	/* N郂[h */
extern const FP			tinib_task[];		/* ^XN̋NԒn */
extern const VP			tinib_stk[];		/* X^bN̈̐擪Ԓn */
extern const UINT16		tinib_stksz[];		/* X^bN̈̃TCY */

/*
 *  ^XNǗubNikernel_cfg.cj
 *
 *  ̑ɁC^XNReLXgۑ邽߂̔z񂪁C^[Qbgˑ
 *  ɒ`D
 */
extern TaskType			tcb_next[];			/* ^XNL[ */
extern UINT8			tcb_tstat[];		/* ^XN */
extern Priority			tcb_curpri[];		/* ݂̗Dx */
extern UINT8			tcb_actcnt[];		/* dNv */
extern EventMaskType	tcb_curevt[];		/* Cxǧݒl */
extern EventMaskType	tcb_waievt[];		/* ҂ĂCxg */
extern ResourceType		tcb_lastres[];		/* ŌɊl\[X */

/*
 *  sԂ̃^XN
 *
 *  sԂ̃^XNȂꍇɂ́CTSKID_NULL ɂD
 */
extern TaskType			runtsk;

/*
 *  ōD揇ʃ^XN
 *
 *  ^XNśCruntsk ƈvDsłԁisԂ܂
 *  s\ԁj̃^XNȂꍇɂ́CTSKID_NULL ɂD
 */
extern TaskType			schedtsk;

/*
 *  fBL[̍ōDx
 *
 *  fBL[ɂ͎s\Ԃ̃^XN݂̂܂ނ̂ŁCs\Ԃ
 *  ^XN̒o̍ōDxێDfBL[̎is\
 *  Ԃ̃^XNj TPRI_MINTASKi0jɂD
 */
extern Priority			nextpri;

/*
 *  ^XNǗW[̏
 */
extern void	task_initialize(void);

/*
 *  ^XN̋N
 *
 *  Ώۃ^XNitskid Ŏw肵^XNjNix~Ԃs
 *  ԂɑJڂD^XN̋NɕKvȏsD
 */
extern BOOL	make_active(TaskType tskid);

/*
 *  słԂւ̈ڍs
 *
 *  Ώۃ^XNitskid Ŏw肵^XNjsłԂɑJڂD
 *  Ώۃ^XN̗DxCōDx^XNischedtskj̗Dx
 *  ꍇɂ́CΏۃ^XNVōDx^XNƂC܂ł̍ō
 *  Dx^XNfBL[̐擪ɓDłȂꍇɂ́CΏ
 *  ^XNfBL[̖ɓDΏۃ^XNōDx^XN
 *  ꍇɁCTRUE ԂD
 */
extern BOOL	make_runnable(TaskType tskid);

/*
 *  ōD揇ʃ^XÑT[`
 *
 *  fBL[ōłD揇ʂ̍^XNT[`CfB
 *  L[OāCōD揇ʃ^XNischedtskjƂDۂɂ́C
 *  fBL[̍ōDx nextpri ɐݒ肳Ă邽߂ɃT[`
 *  ͕KvȂCDx nextpri ̃fBL[̐擪̃^XNōD
 *  ʃ^XNƂDfBL[̃T[`́C̃^XNfBL[
 *  O nextpri XV邽߂ɕKvƂȂD̃T[`ɁC
 *  ready_primap pD
 *  ̊֐́C܂ŎsԂł^XN҂Ԃx~ԂɈ
 *  sɁCɎsׂ^XNIԂ߂ɌĂяoDĂ̊
 *  ł́C܂ł̍ōDx^XN͖D
 */
extern void	search_schedtsk(void);

/*
 *  ^XÑvGvg
 *
 *  ^XNs\ԂɈڍsCōDx^XNsԂɂD
 *  ̊֐߂ɁCdispatch Ăяođ̃^XN֐؂ւ
 *  Ƃz肵ĂD
 */
extern void	preempt(void);

#endif /* _TASK_H_ */
