/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: message.h,v 1.5 2003/12/20 06:51:58 takayuki Exp $
 */

// $Header: /home/CVS/configurator/base/message.h,v 1.5 2003/12/20 06:51:58 takayuki Exp $

#ifndef MESSAGE_H
#define MESSAGE_H

#ifdef _MSC_VER
#  pragma warning(disable:4290) //C++ 㳰λ̵뤵ޤؿ __declspec(nothrow) ǤʤȤΤɽޤ
#  pragma warning(disable:4786) //ǥХåǼ̻Ҥ255ʸڤΤƤޤ
#endif

#include <string>
#include <sstream>
#include <stdarg.h>
#include <stdexcept>

//#include "base/testsuite.h"
#include "base/singleton.h"
#include "base/except.h"

    /*
     *   ʸإѡ饹
     */
class Formatter
{
protected:
    std::string       templatestring;    //ƥץ졼ʸ
    std::stringstream content;           //ʸȽ񼰺Ѥʸǽѥȥ꡼
    bool              accept;            //ǽɤ

        //ΰؤȰư
    void shift(void) throw();

        //̤ΰ (null) ִ
    void shift_all(void) throw();

public:
        //ǥեȥ󥹥ȥ饯
    Formatter(void) throw();

        //󥹥ȥ饯
    Formatter(std::string src) throw();

        //ԡ󥹥ȥ饯
    Formatter(const Formatter & src) throw();

        //ƥץ졼ʸ (ȤϾä)
    void assign(std::string src) throw();

        //ƤΥꥢ
    void clear(void) throw();

        //黻
    Formatter & operator =(const Formatter & src) throw();

        //
    template<class T>
    Formatter & operator << (const T & src) throw()
    {
        std::string::size_type pos;

            //ǽʤ
        if(accept) {
            pos = content.str().size();
            content << src;

                /* ʸǤʤм˰ư */
            if(pos != content.str().size())
                shift();
        }
        return *this;
    }

        //åμФ
    std::string str(void) throw();

        //ɸϥȥ꡼ؤν operator << 
    friend inline std::ostream & operator << (std::ostream & out, Formatter msg) throw()
    {
        out << msg.content.str();
        return out;
    }

//    TESTSUITE_PROTOTYPE(main)
};

    /*
     *   åѤ2бԤäʸإѡ饹
     */
class Message : public Formatter
{
public:
    enum tagLanguage
    {
        ENGLISH  = 0,
        JAPANESE = 1,

        LAST_LANG,              //Ǹΰ
        NEUTRAL  = ENGLISH,     //ɸ
    };

        /* ϥå楯饹 */
    class MessageControl
    {
    protected:
        int language;   //ɤθѤΤ

    public:
            //󥹥ȥ饯
        SINGLETON_CONSTRUCTOR(MessageControl) throw() : language(NEUTRAL) {};

            //
        inline void setLanguage(int _language) throw()  { language = _language; }
        inline int  getLanguage(void) const    throw()  { return language; }

        const char * select(const char * msg1, const char * msg2, va_list vl ) throw();
    };

protected:

        //饹ѥ󥹥ȥ饯
    void _initialize(const char * src1, const char * src2, va_list vl) throw();

public:
        //ǥեȥ󥹥ȥ饯
    Message(void) throw();

        //󥹥ȥ饯 (ñ)
    Message(std::string src) throw();

        //󥹥ȥ饯 (ʣ)
    Message(const char * src1, const char * src2, ... ) throw();

        //ԡ󥹥ȥ饯
    Message(const Message & src) throw();

        //ƥץ졼ʸ (ȤϾä)
    void assign(std::string src) throw() { Formatter::assign(src); }
    void assign(const char * src1, const char * src2, ... ) throw();

        //
    static void selectLanguage(enum tagLanguage lang = NEUTRAL) throw();
        
        //μ
    static enum tagLanguage getCurrentLanguage(void) throw()
    {   return static_cast<enum tagLanguage>(Singleton<MessageControl>::getInstance()->getLanguage());   }

    //TESTSUITE_PROTOTYPE(main)
};


    /*
     *   Ĺʸإѡ饹
     */
class VerboseMessage : public Message
{
public:
        //̤ξĹϾĥ饹
    class VerboseControl
    {
    public:
        bool           verbose;     //ĹϤԤɤ
        std::ostream * out;         //

            //󥹥ȥ饯
        SINGLETON_CONSTRUCTOR(VerboseControl) throw() : verbose(false), out(0)
        {}

            //Ĺ
        template<class T>
        inline const VerboseControl & operator << (const T & src) const throw()
        {
            if(verbose && out != 0)
                (*out) << src;
            return *this;
        }

            //verbose
        void setVerbose(bool _verbose) throw()
        {   verbose = _verbose;   }
        bool getVerbose(void) const throw()
        {   return verbose;   }

            //out
        void setStream(std::ostream * _out) throw()
        {   out = _out;   }
        std::ostream * getStream(void) throw()
        {   return out;   }
    };

        //Ĺϥȥ꡼ (ñ޻ߵĤåѡ饹)
    class VerboseStream
    {
    protected:
        std::ostream * out;

    public:
        VerboseStream(std::ostream * _out = 0) throw() : out(_out) {};

        template<class T>
        VerboseStream & operator << (const T & src) throw()
        {
            if(out != 0)
                (*out) << src;
            return *this;
        }
    };

protected:
        //ǥեȥ󥹥ȥ饯 (ƥ)
    VerboseMessage(void) throw();

public:

        //󥹥ȥ饯
    VerboseMessage(const char * src) throw();
    VerboseMessage(const std::string & src) throw();
    VerboseMessage(const char * src1, const char * src2, ... ) throw();

        //ǥȥ饯
    ~VerboseMessage(void) throw();

        //Ĺ ()
    inline static void setVerbose(bool _verbose) throw()
    {   Singleton<VerboseControl>::getInstance()->setVerbose(_verbose);   }

        //Ĺ襹ȥ꡼ ()
    inline static void setStream(std::ostream * _stream) throw()
    {   Singleton<VerboseControl>::getInstance()->setStream(_stream);   }

        //Ĺξּ
    inline static bool getVerbose(void) throw()
    {   return Singleton<VerboseControl>::getInstance()->getVerbose();   }

        //Ĺ襹ȥ꡼μ (ꤷΤƱΤϽФƤʤ)
    inline static VerboseStream getStream(void) throw()
    {   return VerboseStream(getVerbose() ? Singleton<VerboseControl>::getInstance()->getStream() : 0);   }

    //TESTSUITE_PROTOTYPE(main)
};

    /*
     *   㳰åʸإѡ饹
     */
class ExceptionMessage : public Message
{
public:
        //㳰δ٥٥
    enum tagLevel {
        DEFAULT = 0,
        FATAL   = 1,
        WARNING = 2
    };

#ifdef EXCEPT_H
    class ExceptionMessageException : public Exception
    {
    friend class ExceptionMessage;
    protected:
        ExceptionMessageException(int _code, std::string _details) throw() : Exception("ExceptionMessage", _code, _details) {}
    };
#endif

protected:
    enum tagLevel level;

public:
        //󥹥ȥ饯
    ExceptionMessage(const char * src) throw();
    ExceptionMessage(const std::string & src) throw();
    ExceptionMessage(const char * src1, const char * src2, ...) throw();

    ExceptionMessage(enum tagLevel level = DEFAULT) throw();
    ExceptionMessage(enum tagLevel level, const char * src) throw();
    ExceptionMessage(enum tagLevel level, const std::string & src) throw();
    ExceptionMessage(enum tagLevel level, const char * src1, const char * src2, ...) throw();

    ExceptionMessage(const ExceptionMessage & src) throw();


        //٥٥뻲
    inline bool operator == (enum tagLevel _level) const throw()
    {   return level == _level;   }

        //٥٥뻲
    inline bool operator != (enum tagLevel _level) const throw()
    {   return !(operator ==(_level));   }

        // (ֵͤηMessage &  ExceptionMessage & ˤ뤿ξٹ)
    template<class T>
    inline ExceptionMessage & operator << (const T & src) throw()
    {
        Message::operator << ( src );
        return *this;
    }

#ifdef EXCEPT_H     //Exception饹Ѥ
        //㳰ȯ
    bool throwException(void) throw(Exception)
    {
        ExceptionMessageException exc(level, str());
        return exc.throwException();
    }
        //ޥ˥ԥ졼
    inline ExceptionMessage & operator << ( ExceptionMessage & (* func)(ExceptionMessage &) ) throw(Exception)
    {   return (*func)(*this);   }

#else               //stdexceptѤ
        //㳰ȯ
    template<class T>
    bool throwException(void) throw(T)
    {
        throw T(str());
        return true;
    }
        //ޥ˥ԥ졼
    inline ExceptionMessage & operator << ( ExceptionMessage & (* func)(ExceptionMessage &) ) throw(T)
    {   return (*func)(*this);   }
#endif

    //TESTSUITE_PROTOTYPE(main)
};

#ifdef EXCEPT_H     //Exception饹Ѥ

        //㳰򥹥뤿Υޥ˥ԥ졼
    inline ExceptionMessage & throwException(ExceptionMessage & excmsg) throw(Exception)
    {
        excmsg.throwException();
        return excmsg;
    }

#else
        //㳰򥹥뤿Υޥ˥ԥ졼
    template<class T>
    inline ExceptionMessage & throwException(ExceptionMessage & excmsg) throw(T)
    {
        excmsg.throwException<T>();
        return excmsg;
    }

#endif



    /*
     *   ǥХåʸإѡ饹
     */
class DebugMessage : public Formatter
{
public:
        //̤ξĹϾĥ饹 (󥰥ȥˤΤVerboseControlƱΤ򥯥饹)
    class DebugControl : public VerboseMessage::VerboseControl
    { public: SINGLETON_CONSTRUCTOR_(DebugControl) throw() : VerboseMessage::VerboseControl(_singleton) {} };


protected:
        //ǥեȥ󥹥ȥ饯 (ƥ)
    DebugMessage(void) throw();

public:

        //󥹥ȥ饯
    DebugMessage(std::string src) throw();

        //ǥȥ饯
    ~DebugMessage(void) throw();

        //Ĺ ()
    inline static void setVerbose(bool _verbose) throw()
    {   Singleton<DebugControl>::getInstance()->setVerbose(_verbose);   }

        //Ĺ襹ȥ꡼ ()
    inline static void setStream(std::ostream * _stream) throw()
    {   Singleton<DebugControl>::getInstance()->setStream(_stream);   }

        //Ĺξּ
    inline static bool getVerbose(void) throw()
    {   return Singleton<DebugControl>::getInstance()->getVerbose();   }

        //Ĺ襹ȥ꡼μ (ꤷΤƱΤϽФƤʤ)
    inline static VerboseMessage::VerboseStream getStream(void) throw()
    {   return VerboseMessage::VerboseStream(getVerbose() ? Singleton<DebugControl>::getInstance()->getStream() : 0);   }

//  TESTSUITE_PROTOTYPE(main)
};


#endif  //MESSAGE_H


