/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;
    public static final double NaN = Double.NaN;
    static final float PI2 = 1.5707964f;
    static final double ln10 = 2.30258509299405;
    static final double ln2 = 0.69314718055995;
    private static final float LOWER_BOUND = 0.9999999f;
    private static final float UPPER_BOUND = 1.0f;
    private static Random RAND = new Random(System.currentTimeMillis());

    private Math() {
    }

    private static double ArcTan(double x) {
        double x2 = x * x;
        return (0.7162721157073975 + 0.2996857762336731 * x2) * x / (0.7163164615631104 + (0.5377299189567566 + 0.039516203105449677 * x2) * x2);
    }

    public static double ceil(double a) {
        return a < 0.0 ? (int)a : (int)(a + 1.0);
    }

    public static double floor(double a) {
        return a < 0.0 ? (int)(a - 1.0) : (int)a;
    }

    public static int round(float a) {
        return (int)Math.floor(a + 0.5f);
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static double min(double a, double b) {
        return a < b ? a : b;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static double max(double a, double b) {
        return a > b ? a : b;
    }

    public static double random() {
        int MAX_INT = Integer.MAX_VALUE;
        int n = Integer.MAX_VALUE;
        while (n == Integer.MAX_VALUE) {
            n = Math.abs(RAND.nextInt());
        }
        return (double)n * 4.656612875245797E-10;
    }

    public static double exp(double a) {
        double end;
        boolean neg;
        boolean bl = neg = a < 0.0;
        if (a < 0.0) {
            a = -a;
        }
        int fac = 1;
        double term = a;
        double sum = 0.0;
        double oldsum = 0.0;
        while ((end = (sum += (term *= a / (double)(++fac))) / (oldsum = sum)) < 0.9999998807907104 || end > 1.0) {
        }
        return neg ? 1.0 / sum : (sum += 1.0);
    }

    public static double log(double x) {
        double zeta;
        double p;
        if (x == 0.0) {
            return Double.NaN;
        }
        if (x < 1.0) {
            return -Math.log(1.0 / x);
        }
        double m = 0.0;
        for (p = 1.0; p <= x; p *= 2.0) {
            m += 1.0;
        }
        m -= 1.0;
        double z = x / (p / 2.0);
        double n = zeta = (1.0 - z) / (1.0 + z);
        double ln = zeta;
        double zetasup = zeta * zeta;
        int j = 1;
        double newln;
        double term;
        while (!((term = ln / (newln = ln + (n *= zetasup) / (double)(2 * j + 1))) >= 0.9999998807907104) || !(term <= 1.0)) {
            ln = newln;
            ++j;
        }
        return m * 0.69314718055995 - 2.0 * ln;
    }

    public static double pow(double a, double b) {
        return Math.exp(b * Math.log(a));
    }

    public static double abs(double a) {
        return a < 0.0 ? -a : a;
    }

    public static int abs(int a) {
        return a < 0 ? -a : a;
    }

    public static double sin(double x) {
        int n = (int)(x / 1.5707963705062866) + 1;
        if (n < 1) {
            --n;
        }
        x = (n & 2) == 0 ? (x -= (double)((float)(n & 0xFFFFFFFE) * 1.5707964f)) : -(x - (double)((float)(n & 0xFFFFFFFE) * 1.5707964f));
        double x2 = x * x;
        return (0.9238318800926208 - 0.09595498442649841 * x2) * x / (0.9238400459289551 + (0.0579729825258255 + 0.0020317912567406893 * x2) * x2);
    }

    public static double cos(double x) {
        int n = (int)(x / 1.5707963705062866) + 1;
        if (n < 1) {
            --n;
        }
        double x2 = (x -= (double)((float)(n & 0xFFFFFFFE) * 1.5707964f)) * x;
        float si = 1.0f;
        if ((n & 2) != 0) {
            si = -1.0f;
        }
        return (double)si * (0.945709228515625 + (-0.4305320680141449 + 0.01914992928504944 * x2) * x2) / (0.9457093477249146 + (0.04232119768857956 + 9.106317884288728E-4 * x2) * x2);
    }

    public static double sqrt(double x) {
        double root = x;
        double guess = 0.0;
        if (x < 0.0) {
            return Double.NaN;
        }
        for (int i = 0; i < 16 && (guess > x * 1.0000004768371582 || guess < x * 0.9999995231628418); ++i) {
            root = (root + x / root) * 0.5;
            guess = root * root;
        }
        return root;
    }

    public static double tan(double a) {
        return Math.sin(a) / Math.cos(a);
    }

    public static double atan(double x) {
        return Math.atan2(x, 1.0);
    }

    public static double atan2(double y, double x) {
        float ax = (float)Math.abs(x);
        float ay = (float)Math.abs(y);
        if ((double)ax < 1.0E-7 && (double)ay < 1.0E-7) {
            return 0.0;
        }
        if (ax > ay) {
            if (x < 0.0) {
                if (y >= 0.0) {
                    return Math.ArcTan(y / x) + Math.PI;
                }
                return Math.ArcTan(y / x) - Math.PI;
            }
            return Math.ArcTan(y / x);
        }
        if (y < 0.0) {
            return Math.ArcTan(-x / y) - 1.5707963267948966;
        }
        return Math.ArcTan(-x / y) + 1.5707963267948966;
    }

    public static double acos(double a) {
        if (a < -1.0 || a > 1.0) {
            return Double.NaN;
        }
        return 1.5707963267948966 - Math.atan(a / Math.sqrt(1.0 - a * a));
    }

    public static double asin(double a) {
        return Math.atan(a / Math.sqrt(1.0 - a * a));
    }

    public static double toDegrees(double angrad) {
        return angrad * 57.29577951308232;
    }

    public static double toRadians(double angdeg) {
        return angdeg * (Math.PI / 180);
    }
}

