/*
 * Decompiled with CFR 0.152.
 */
package java.util;

public class Random {
    private int iPrevSeed = 1;
    private int iSeed;
    private boolean haveNextNextGaussian;
    private double nextNextGaussian;

    public Random(long seed) {
        this.iSeed = (int)seed;
    }

    public Random() {
        this(System.currentTimeMillis());
    }

    public int nextInt() {
        int pNewSeed = this.iSeed * 48271 ^ this.iPrevSeed;
        this.iPrevSeed = this.iSeed;
        this.iSeed = pNewSeed;
        return pNewSeed;
    }

    public int nextInt(int n) {
        int m = this.nextInt() % n;
        return m >= 0 ? m : m + n;
    }

    public boolean nextBoolean() {
        int nextInt = this.nextInt(2);
        boolean nextBoolean = nextInt == 1;
        return nextBoolean;
    }

    public double nextDouble() {
        return Math.random();
    }

    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = Math.sqrt(-2.0 * Math.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }
}

