/*
 * Decompiled with CFR 0.152.
 */
package lejos.navigation;

import lejos.navigation.Navigator;
import lejos.navigation.Pilot;
import lejos.nxt.Motor;

public class TachoNavigator
implements Navigator {
    protected float _heading = 0.0f;
    private float _x = 0.0f;
    private float _y = 0.0f;
    protected int _left0 = 0;
    protected int _right0 = 0;
    protected Pilot _pilot;
    private boolean _updated = false;

    public TachoNavigator(float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor, boolean reverse) {
        this._pilot = new Pilot(wheelDiameter, trackWidth, leftMotor, rightMotor, reverse);
    }

    public TachoNavigator(float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor) {
        this._pilot = new Pilot(wheelDiameter, trackWidth, leftMotor, rightMotor);
    }

    public TachoNavigator(Pilot pilot) {
        this._pilot = pilot;
    }

    public TachoNavigator(float wheelDiameter, float driveLength) {
        this(wheelDiameter, driveLength, Motor.A, Motor.C);
    }

    public Pilot getPilot() {
        return this._pilot;
    }

    public float getX() {
        return this._x;
    }

    public float getY() {
        return this._y;
    }

    public float getAngle() {
        return this._heading;
    }

    public void setPosition(float x, float y, float directionAngle) {
        this._x = x;
        this._y = y;
        this._heading = directionAngle;
    }

    public void setSpeed(int speed) {
        this._pilot.setSpeed(speed);
    }

    public void forward() {
        this._updated = false;
        this._pilot.resetTachoCount();
        this._right0 = 0;
        this._left0 = 0;
        this._pilot.forward();
    }

    public void backward() {
        this._updated = false;
        this._pilot.resetTachoCount();
        this._right0 = 0;
        this._left0 = 0;
        this._pilot.backward();
    }

    public void stop() {
        this._pilot.stop();
        this.updatePosition();
    }

    public boolean isMoving() {
        return this._pilot.isMoving();
    }

    public void travel(float distance) {
        this.travel(distance, false);
    }

    public void travel(float distance, boolean immediateReturn) {
        this._updated = false;
        this._pilot.resetTachoCount();
        this._right0 = 0;
        this._left0 = 0;
        this._pilot.travel(distance, immediateReturn);
        if (!immediateReturn) {
            this.updatePosition();
        }
    }

    public void rotateLeft() {
        this._updated = false;
        this._pilot.resetTachoCount();
        this._right0 = 0;
        this._left0 = 0;
        this._pilot.steer(200);
    }

    public void rotateRight() {
        this._updated = false;
        this._pilot.resetTachoCount();
        this._right0 = 0;
        this._left0 = 0;
        this._pilot.steer(-200);
    }

    public void rotate(float angle) {
        this.rotate(angle, false);
    }

    public void rotate(float angle, boolean immediateReturn) {
        this._updated = false;
        int turnAngle = Math.round(this.normalize(angle));
        this._pilot.resetTachoCount();
        this._right0 = 0;
        this._left0 = 0;
        this._pilot.rotate(turnAngle, immediateReturn);
        if (!immediateReturn) {
            this.updatePosition();
        }
    }

    public void rotateTo(float angle) {
        this.rotateTo(angle, false);
    }

    public void rotateTo(float angle, boolean immediateReturn) {
        float turnAngle = this.normalize(angle - this._heading);
        this.rotate(turnAngle, immediateReturn);
    }

    public void goTo(float x, float y) {
        this.rotateTo(this.angleTo(x, y));
        this.travel(this.distanceTo(x, y));
    }

    public void goTo(float x, float y, boolean immediateReturn) {
        this.rotateTo(this.angleTo(x, y));
        this.travel(this.distanceTo(x, y), immediateReturn);
    }

    public float distanceTo(float x, float y) {
        float dx = x - this._x;
        float dy = y - this._y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public float angleTo(float x, float y) {
        float dx = x - this._x;
        float dy = y - this._y;
        return (float)Math.toDegrees(Math.atan2(dy, dx));
    }

    public void updatePosition() {
        int temp = 0;
        int left = this._pilot.getLeftCount();
        int right = this._pilot.getRightCount();
        temp = left;
        this._left0 = temp;
        temp = right;
        this._right0 = temp;
        if ((left -= this._left0) == 0 && (right -= this._right0) == 0) {
            return;
        }
        int outside = 0;
        int inside = 0;
        int direction = 0;
        float dx = 0.0f;
        float dy = 0.0f;
        if (Math.abs(left) < Math.abs(right)) {
            outside = right;
            inside = left;
            direction = 1;
        } else {
            outside = left;
            inside = right;
            direction = -1;
        }
        float turnAngle = (float)(direction * (outside - inside)) * this._pilot._wheelDiameter / (2.0f * this._pilot._trackWidth);
        boolean approx = false;
        if ((double)(1.0f * (float)inside / (float)outside) > 0.98) {
            float distance = 0.5f * (float)(inside + outside) / this._pilot._degPerDistance;
            float projection = (float)Math.toRadians(this._heading + turnAngle / 2.0f);
            dx = distance * (float)Math.cos(projection);
            dy = distance * (float)Math.sin(projection);
            approx = true;
        } else {
            float turnRadius = this._pilot._trackWidth * (float)(outside + inside) / (float)(2 * (outside - inside));
            double headingRad = Math.toRadians(this._heading);
            if (direction == -1) {
                headingRad += Math.PI;
            }
            double turnRad = Math.toRadians(turnAngle);
            dx = turnRadius * (float)(Math.sin(headingRad + turnRad) - Math.sin(headingRad));
            dy = turnRadius * (float)(Math.cos(headingRad) - Math.cos(headingRad + turnRad));
        }
        this._heading = this.normalize(this._heading + turnAngle);
        this._x += dx;
        this._y += dy;
        if (approx) {
            this._heading -= turnAngle / 2.0f;
        }
        this._updated = true;
    }

    public void turn(float radius) {
        this._updated = false;
        this._pilot.resetTachoCount();
        this._right0 = 0;
        this._left0 = 0;
        this._pilot.steer(this.turnRate(radius));
    }

    public void turn(float radius, int angle) {
        this.turn(radius, angle, false);
    }

    public void turn(float radius, int angle, boolean immediateReturn) {
        this._updated = false;
        this._pilot.resetTachoCount();
        this._right0 = 0;
        this._left0 = 0;
        this._pilot.steer(this.turnRate(radius), angle, immediateReturn);
        if (!immediateReturn) {
            this.updatePosition();
        }
    }

    private float normalize(float angle) {
        float a;
        for (a = angle; a > 180.0f; a -= 360.0f) {
        }
        while (a < -180.0f) {
            a += 360.0f;
        }
        return a;
    }

    private int turnRate(float radius) {
        int direction = 1;
        if (radius < 0.0f) {
            direction = -1;
            radius = -radius;
        }
        float ratio = (2.0f * radius - this._pilot._trackWidth) / (2.0f * radius + this._pilot._trackWidth);
        return Math.round((float)(direction * 100) * (1.0f - ratio));
    }
}

