/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.I2CPort;
import lejos.nxt.I2CSensor;

public class CompassSensor
extends I2CSensor {
    byte[] buf = new byte[2];
    private static final String MINDSENSORS_ID = "mndsnsrs";
    private boolean isMindsensors = this.getProductID().equals("mndsnsrs");
    private float cartesianCalibrate = 0.0f;
    private static final byte COMMAND = 65;
    private static final byte BEGIN_CALIBRATION = 67;
    private static final byte END_CALIBRATION = 68;
    private static final byte MODE_CONTROL = 65;
    private static final byte MEASUREMENT_MODE = 0;
    private static final byte CALIBRATE_MODE = 67;

    public CompassSensor(I2CPort port) {
        super(port);
    }

    public float getDegrees() {
        int ret = this.getData(66, this.buf, 2);
        if (ret != 0) {
            return -1.0f;
        }
        if (this.isMindsensors) {
            int dHeading = 0xFF & this.buf[0];
            dHeading *= 360;
            return dHeading /= 255;
        }
        return ((this.buf[0] & 0xFF) << 1) + this.buf[1];
    }

    public float getDegreesCartesian() {
        float degrees = this.cartesianCalibrate - this.getDegrees();
        if (degrees >= 360.0f) {
            degrees -= 360.0f;
        }
        if (degrees < 0.0f) {
            degrees += 360.0f;
        }
        return degrees;
    }

    public void resetCartesianZero() {
        this.cartesianCalibrate = this.getDegrees();
    }

    public void startCalibration() {
        this.buf[0] = 67;
        super.sendData(65, this.buf, 1);
    }

    public void stopCalibration() {
        this.buf[0] = this.isMindsensors ? 68 : 0;
        super.sendData(65, this.buf, 1);
    }
}

