/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Queue;
import lejos.nxt.Battery;
import lejos.nxt.LCD;
import lejos.nxt.Motor;
import lejos.nxt.MotorPort;
import lejos.nxt.SensorPort;
import lejos.nxt.Sound;
import lejos.nxt.comm.Bluetooth;

public class LCP {
    private static byte[] i2cReply = new byte[16];
    private static int i2cLen = 0;
    private static File[] files = null;
    private static String[] fileNames = null;
    private static int fileIdx = -1;
    private static String currentProgram = null;
    private static File file = null;
    private static FileOutputStream out = null;
    private static FileInputStream in = null;
    private static int numFiles;
    private static char[] charBuffer;
    public static Queue[] inBoxes;
    public static byte DIRECT_COMMAND_REPLY;
    public static byte SYSTEM_COMMAND_REPLY;
    public static byte REPLY_COMMAND;
    public static byte DIRECT_COMMAND_NOREPLY;
    public static byte SYSTEM_COMMAND_NOREPLY;
    public static final byte START_PROGRAM = 0;
    public static final byte STOP_PROGRAM = 1;
    public static final byte PLAY_SOUND_FILE = 2;
    public static final byte PLAY_TONE = 3;
    public static final byte SET_OUTPUT_STATE = 4;
    public static final byte SET_INPUT_MODE = 5;
    public static final byte GET_OUTPUT_STATE = 6;
    public static final byte GET_INPUT_VALUES = 7;
    public static final byte RESET_SCALED_INPUT_VALUE = 8;
    public static final byte MESSAGE_WRITE = 9;
    public static final byte RESET_MOTOR_POSITION = 10;
    public static final byte GET_BATTERY_LEVEL = 11;
    public static final byte STOP_SOUND_PLAYBACK = 12;
    public static final byte KEEP_ALIVE = 13;
    public static final byte LS_GET_STATUS = 14;
    public static final byte LS_WRITE = 15;
    public static final byte LS_READ = 16;
    public static final byte GET_CURRENT_PROGRAM_NAME = 17;
    public static final byte MESSAGE_READ = 19;
    public static byte NXJ_DISCONNECT;
    public static byte NXJ_DEFRAG;
    public static final byte OPEN_READ = -128;
    public static final byte OPEN_WRITE = -127;
    public static final byte READ = -126;
    public static final byte WRITE = -125;
    public static final byte CLOSE = -124;
    public static final byte DELETE = -123;
    public static final byte FIND_FIRST = -122;
    public static final byte FIND_NEXT = -121;
    public static final byte GET_FIRMWARE_VERSION = -120;
    public static final byte OPEN_WRITE_LINEAR = -119;
    public static final byte OPEN_READ_LINEAR = -118;
    public static final byte OPEN_WRITE_DATA = -117;
    public static final byte OPEN_APPEND_DATA = -116;
    public static final byte BOOT = -105;
    public static final byte SET_BRICK_NAME = -104;
    public static final byte GET_DEVICE_INFO = -101;
    public static final byte DELETE_USER_FLASH = -96;
    public static final byte POLL_LENGTH = -95;
    public static final byte POLL = -94;
    public static final byte NXJ_FIND_FIRST = -74;
    public static final byte NXJ_FIND_NEXT = -73;
    public static final byte MAILBOX_EMPTY = 64;
    public static final byte FILE_NOT_FOUND = -122;
    public static final byte INSUFFICIENT_MEMORY = -5;
    public static final byte DIRECTORY_FULL = -4;
    public static final byte UNDEFINED_ERROR = -118;
    public static final byte NOT_IMPLEMENTED = -3;

    private LCP() {
    }

    public static int emulateCommand(byte[] cmd, int cmdLen, byte[] reply) {
        byte mode;
        int i;
        int len = 3;
        for (int i2 = 0; i2 < reply.length; ++i2) {
            reply[i2] = 0;
        }
        reply[0] = REPLY_COMMAND;
        reply[1] = cmd[1];
        byte cmdId = cmd[1];
        if (cmdId == 0) {
            LCP.init_files();
            currentProgram = LCP.getFile(cmd, 2);
            if (fileNames != null) {
                for (i = 0; i < fileNames.length; ++i) {
                    if (!currentProgram.equals(fileNames[i])) continue;
                    files[i].exec();
                }
            }
        }
        if (cmdId == 17 && currentProgram != null) {
            for (i = 0; i < currentProgram.length() && i < 19; ++i) {
                reply[3 + i] = (byte)currentProgram.charAt(i);
            }
        }
        if (cmdId == 11) {
            LCP.setReplyShortInt(Battery.getVoltageMilliVolt(), reply, 3);
            len = 5;
        }
        if (cmdId == 2) {
            LCP.init_files();
            String soundFile = LCP.getFile(cmd, 3);
            File f = new File(soundFile);
            Sound.playSample(f, 50);
        }
        if (cmdId == 3) {
            Sound.playTone(LCP.getShortInt(cmd, 2), LCP.getShortInt(cmd, 4));
        }
        if (cmdId == -120) {
            reply[3] = 2;
            reply[4] = 1;
            reply[5] = 3;
            reply[6] = 1;
            len = 7;
        }
        if (cmdId == -101) {
            byte[] name = Bluetooth.getFriendlyName();
            for (int i3 = 0; i3 < 15; ++i3) {
                reply[3 + i3] = name[i3];
            }
            byte[] address = Bluetooth.getLocalAddress();
            for (int i4 = 0; i4 < 7; ++i4) {
                reply[18 + i4] = address[i4];
            }
            LCP.setReplyInt(File.freeMemory(), reply, 29);
            len = 33;
        }
        if (cmdId == -104) {
            byte[] name = new byte[16];
            for (int i5 = 0; i5 < 16; ++i5) {
                name[i5] = cmd[i5 + 2];
            }
            Bluetooth.setFriendlyName(name);
            len = 4;
        }
        if (cmdId == 6) {
            byte turn_ratio;
            byte port = cmd[2];
            Motor m = port == 0 ? Motor.A : (port == 1 ? Motor.B : Motor.C);
            int tacho = m.getTachoCount();
            reply[3] = port;
            reply[4] = (byte)(m.getSpeed() * 100 / 900);
            mode = 0;
            if (m.isMoving()) {
                mode = 1;
            }
            reply[5] = mode;
            byte regulation_mode = 0;
            if (m.isMoving()) {
                mode = 1;
            }
            reply[6] = regulation_mode;
            reply[7] = turn_ratio = 0;
            int run_state = 0;
            if (m.isMoving()) {
                run_state = 32;
            }
            reply[8] = run_state;
            LCP.setReplyInt(tacho, reply, 13);
            LCP.setReplyInt(tacho, reply, 21);
            len = 25;
        }
        if (cmdId == 7) {
            byte port = cmd[2];
            int raw = SensorPort.PORTS[port].readRawValue();
            int scaled = SensorPort.PORTS[port].readValue();
            int norm = 1024 - raw;
            reply[3] = port;
            reply[4] = 1;
            reply[6] = (byte)SensorPort.PORTS[port].getType();
            reply[7] = (byte)SensorPort.PORTS[port].getMode();
            LCP.setReplyShortInt(raw, reply, 8);
            LCP.setReplyShortInt(norm, reply, 10);
            LCP.setReplyShortInt(scaled, reply, 12);
            len = 16;
        }
        if (cmdId == 5) {
            byte port = cmd[2];
            int sensorType = cmd[3] & 0xFF;
            int sensorMode = cmd[4] & 0xFF;
            SensorPort.PORTS[port].setTypeAndMode(sensorType, sensorMode);
        }
        if (cmdId == 4) {
            byte motorid = cmd[2];
            byte power = cmd[3];
            int speed = Math.abs(power) * 900 / 100;
            mode = cmd[4];
            byte regMode = cmd[5];
            byte turnRatio = cmd[6];
            byte runState = cmd[7];
            int tacholimit = LCP.getInt(cmd, 8);
            Motor m = null;
            for (int i6 = 0; i6 < 3; ++i6) {
                if (motorid == 0 || motorid < 0 && i6 == 0) {
                    m = Motor.A;
                } else if (motorid == 1 || motorid < 0 && i6 == 1) {
                    m = Motor.B;
                } else if (motorid == 2 || motorid < 0 && i6 == 2) {
                    m = Motor.C;
                }
                m.setSpeed(speed);
                if (power < 0) {
                    tacholimit = -tacholimit;
                }
                if (power == 0) {
                    m.stop();
                }
                if (tacholimit != 0) {
                    m.rotate(tacholimit, true);
                }
                if ((mode | 1) != 0 && power != 0 && tacholimit == 0) {
                    if (power > 0) {
                        m.forward();
                    } else {
                        m.backward();
                    }
                }
                if (motorid >= 0) break;
            }
        }
        if (cmdId == 10 && cmd[3] == 0) {
            MotorPort.resetTachoCountById(cmd[2]);
        }
        if (cmdId == 13) {
            len = 7;
        }
        if (cmdId == 15) {
            byte port = cmd[2];
            byte txLen = cmd[3];
            int rxLen = cmd[4];
            SensorPort.i2cEnableById(port);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            int ret = SensorPort.i2cStartById(port, cmd[5] >> 1, cmd[6], rxLen, i2cReply, rxLen, 0);
            while (SensorPort.i2cBusyById(port) != 0) {
                Thread.yield();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            i2cLen = rxLen;
        }
        if (cmdId == 16) {
            reply[3] = (byte)i2cLen;
            for (int i7 = 0; i7 < 16; ++i7) {
                reply[i7 + 4] = i2cReply[i7];
            }
            len = 20;
            i2cLen = 0;
        }
        if (cmdId == 14) {
            reply[3] = (byte)i2cLen;
            len = 4;
        }
        if (cmdId == -128) {
            LCP.init_files();
            file = new File(LCP.getFile(cmd, 2));
            try {
                in = new FileInputStream(file);
                int size = file.length();
                LCP.setReplyInt(size, reply, 4);
            }
            catch (Exception e) {
                reply[2] = -122;
            }
            len = 8;
        }
        if (cmdId == -127) {
            int size = LCP.getInt(cmd, 22);
            LCP.init_files();
            if (size > File.freeMemory()) {
                reply[2] = -5;
            } else {
                try {
                    file = new File(LCP.getFile(cmd, 2));
                    if (file.exists()) {
                        file.delete();
                        --numFiles;
                    }
                    file.createNewFile();
                    fileNames = new String[++numFiles];
                    for (int j = 0; j < numFiles; ++j) {
                        LCP.fileNames[j] = files[j].getName();
                    }
                    out = new FileOutputStream(file);
                }
                catch (Exception e) {
                    files = null;
                    File.reset();
                    LCP.init_files();
                    reply[2] = -4;
                }
            }
            len = 4;
        }
        if (cmdId == -119) {
            reply[2] = -3;
            len = 4;
        }
        if (cmdId == -117) {
            reply[2] = -3;
            len = 4;
        }
        if (cmdId == -116) {
            reply[2] = -122;
            len = 8;
        }
        if (cmdId == NXJ_DEFRAG) {
            try {
                File.defrag();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (cmdId == -122 || cmdId == -74) {
            LCP.init_files();
            len = cmdId == -122 ? 28 : 32;
            if (numFiles == 0) {
                reply[2] = -122;
            } else {
                for (int i8 = 0; i8 < fileNames[0].length(); ++i8) {
                    reply[4 + i8] = (byte)fileNames[0].charAt(i8);
                }
                fileIdx = 1;
                int size = files[0].length();
                LCP.setReplyInt(size, reply, 24);
                if (cmdId == -74) {
                    int startPage = files[0].getPage();
                    LCP.setReplyInt(startPage, reply, 28);
                }
            }
        }
        if (cmdId == -121 || cmdId == -73) {
            len = cmdId == -121 ? 28 : 32;
            if (fileNames == null || fileIdx >= fileNames.length) {
                reply[2] = -122;
            } else {
                for (int i9 = 0; i9 < fileNames[fileIdx].length(); ++i9) {
                    reply[4 + i9] = (byte)fileNames[fileIdx].charAt(i9);
                }
                int size = files[fileIdx].length();
                LCP.setReplyInt(size, reply, 24);
                if (cmdId == -73) {
                    int startPage = files[fileIdx].getPage();
                    LCP.setReplyInt(startPage, reply, 28);
                }
                ++fileIdx;
            }
        }
        if (cmdId == -126) {
            int numBytes = LCP.getShortInt(cmd, 3);
            int bytesRead = 0;
            try {
                bytesRead = in.read(reply, 6, numBytes);
                LCP.setReplyShortInt(bytesRead, reply, 4);
            }
            catch (IOException ioe) {
                reply[2] = -118;
            }
            len = bytesRead + 6;
        }
        if (cmdId == -125) {
            int dataLen = cmdLen - 3;
            try {
                out.write(cmd, 3, dataLen);
                LCP.setReplyShortInt(dataLen, reply, 4);
            }
            catch (Exception ioe) {
                reply[2] = -118;
            }
            len = 6;
        }
        if (cmdId == -123) {
            boolean deleted = false;
            len = 23;
            String fileName = LCP.getFile(cmd, 2);
            if (fileNames != null) {
                for (int i10 = 0; i10 < fileNames.length; ++i10) {
                    int j;
                    if (!fileName.equals(fileNames[i10])) continue;
                    files[i10].delete();
                    for (j = 0; j < fileName.length(); ++j) {
                        reply[j + 3] = (byte)fileName.charAt(i10);
                    }
                    deleted = true;
                    fileNames = new String[--numFiles];
                    for (j = 0; j < numFiles; ++j) {
                        LCP.fileNames[j] = files[j].getName();
                    }
                    break;
                }
            }
            if (!deleted) {
                reply[2] = -122;
            }
        }
        if (cmdId == -124) {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception ioe) {
                    reply[2] = -118;
                }
                out = null;
            }
            len = 4;
        }
        if (cmdId == 19) {
            Queue inBox = inBoxes[cmd[2]];
            reply[3] = cmd[3];
            if (inBox == null || inBox.empty()) {
                reply[2] = 64;
            } else {
                String msg = (String)(cmd[4] == 0 ? inBox.peek() : inBox.pop());
                int msgLen = msg.length();
                reply[4] = (byte)(msgLen > 58 ? 58 : msgLen);
                for (int i11 = 0; i11 < 58 && i11 < msgLen; ++i11) {
                    reply[5 + i11] = (byte)msg.charAt(i11);
                }
            }
            LCD.refresh();
            len = 64;
        }
        return len;
    }

    public static void messageWrite(int mailbox, String msg) {
        if (mailbox < inBoxes.length) {
            if (inBoxes[mailbox] == null) {
                LCP.inBoxes[mailbox] = new Queue();
            }
            inBoxes[mailbox].push(msg);
        }
    }

    private static int getShortInt(byte[] cmd, int i) {
        return (cmd[i] & 0xFF) + ((cmd[i + 1] & 0xFF) << 8);
    }

    private static int getInt(byte[] cmd, int i) {
        return (cmd[i] & 0xFF) + ((cmd[i + 1] & 0xFF) << 8) + ((cmd[i + 2] & 0xFF) << 16) + ((cmd[i + 3] & 0xFF) << 24);
    }

    private static byte getLSB(int i) {
        return (byte)(i & 0xFF);
    }

    private static byte getMSB(int i) {
        return (byte)(i >> 8 & 0xFF);
    }

    private static byte getMSB1(int i) {
        return (byte)(i >> 16 & 0xFF);
    }

    private static byte getMSB2(int i) {
        return (byte)(i >> 24 & 0xFF);
    }

    private static void setReplyInt(int n, byte[] reply, int start) {
        reply[start] = LCP.getLSB(n);
        reply[start + 1] = LCP.getMSB(n);
        reply[start + 2] = LCP.getMSB1(n);
        reply[start + 3] = LCP.getMSB2(n);
    }

    private static void setReplyShortInt(int n, byte[] reply, int start) {
        reply[start] = LCP.getLSB(n);
        reply[start + 1] = LCP.getMSB(n);
    }

    private static void init_files() {
        if (files == null) {
            int i;
            files = File.listFiles();
            numFiles = 0;
            for (i = 0; i < files.length && files[i] != null; ++i) {
                ++numFiles;
            }
            fileNames = new String[numFiles];
            for (i = 0; i < numFiles; ++i) {
                LCP.fileNames[i] = files[i].getName();
            }
        }
    }

    private static String getFile(byte[] cmd, int start) {
        int i;
        int filenameLength = 0;
        for (i = 0; i < 20 && cmd[i + start] != 0; ++i) {
            ++filenameLength;
        }
        for (i = 0; i < filenameLength; ++i) {
            LCP.charBuffer[i] = (char)cmd[i + start];
        }
        return new String(charBuffer, 0, filenameLength);
    }

    static {
        charBuffer = new char[20];
        inBoxes = new Queue[20];
        DIRECT_COMMAND_REPLY = 0;
        SYSTEM_COMMAND_REPLY = 1;
        REPLY_COMMAND = (byte)2;
        DIRECT_COMMAND_NOREPLY = (byte)-128;
        SYSTEM_COMMAND_NOREPLY = (byte)-127;
        NXJ_DISCONNECT = (byte)32;
        NXJ_DEFRAG = (byte)33;
    }
}

