/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import java.io.OutputStream;
import lejos.nxt.comm.NXTConnection;

public class NXTOutputStream
extends OutputStream {
    private byte[] buffer;
    private int numBytes = 0;
    private NXTConnection conn = null;

    NXTOutputStream(NXTConnection conn, int buffSize) {
        this.conn = conn;
        this.buffer = new byte[buffSize];
    }

    public void write(int b) {
        if (this.numBytes == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.numBytes] = (byte)b;
        ++this.numBytes;
    }

    public void flush() {
        if (this.numBytes > 0) {
            this.conn.write(this.buffer, this.numBytes);
            this.numBytes = 0;
        }
    }
}

