/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.debug;

import lejos.nxt.Button;
import lejos.nxt.LCD;
import lejos.nxt.Sound;
import lejos.nxt.debug.DebugInterface;
import lejos.nxt.debug.DebugObject;
import lejos.nxt.debug.DebugStackFrame;
import lejos.nxt.debug.DebugThread;
import lejos.nxt.debug.DebugThreads;

public class DebugMonitor {
    static String[] states = new String[]{"N", "D", "I", "R", "E", "W", "S"};

    static void displayException(DebugInterface info) {
        DebugStackFrame fi = new DebugStackFrame(info);
        DebugObject oi = new DebugObject(info);
        System.err.println("Java Exception");
        System.err.println("Class: " + oi.getClassIndex(info.exception));
        System.err.println("Method: " + info.method);
        int sp = info.frame - 1;
        for (int i = 3; i < 8 && sp-- > 0; ++i) {
            System.err.println("Called from: " + fi.getMethodIndex(info.thread, sp));
        }
    }

    static void displayThreads(DebugInterface info) {
        DebugStackFrame fi = new DebugStackFrame(info);
        DebugThread[] threads = info.threads;
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null) continue;
            DebugThread start = threads[i];
            DebugThread th = threads[i];
            do {
                String out = "";
                out = out + th.threadId;
                out = out + (th == info.thread ? "*" : states[th.state & 0x7F]);
                int sp = th.stackFrameArraySize;
                for (int j = 0; j < 3 && sp-- > 0; ++j) {
                    out = out + " " + fi.getMethodIndex(th, sp);
                }
                System.err.println(out);
            } while ((th = th.nextThread) != start);
        }
    }

    public static void main(String[] args) throws Exception {
        DebugInterface monitor = DebugInterface.get();
        DebugInterface.eventOptions(1, 1);
        DebugInterface.eventOptions(2, 1);
        Thread prog = new Thread(){

            public void run() {
                DebugInterface.executeProgram(1);
            }
        };
        Thread.currentThread().setPriority(10);
        prog.start();
        while (true) {
            Thread.currentThread().setDaemon(true);
            int event = monitor.waitEvent(0);
            Thread.currentThread().setDaemon(false);
            LCD.clear();
            switch (event) {
                case 1: {
                    DebugMonitor.displayException(monitor);
                    break;
                }
                case 2: {
                    DebugMonitor.displayThreads(monitor);
                }
            }
            LCD.refresh();
            Sound.playTone(73, 150);
            Sound.pause(300);
            Sound.playTone(62, 500);
            while (Button.readButtons() != 0) {
                Thread.yield();
            }
            DebugInterface.eventOptions(2, 1);
            Button.waitForPress();
            if (Button.ESCAPE.isPressed()) {
                System.exit(1);
            }
            LCD.clear();
            monitor.clear();
            DebugThreads.resumeThread(null);
        }
    }
}

