/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.remote;

import java.io.IOException;
import lejos.nxt.Motor;
import lejos.nxt.comm.DeviceInfo;
import lejos.nxt.comm.FirmwareInfo;
import lejos.nxt.comm.NXTCommand;
import lejos.nxt.remote.RemoteBattery;
import lejos.nxt.remote.RemoteMotorPort;
import lejos.nxt.remote.RemoteSensorPort;

public class RemoteNXT {
    private NXTCommand nxtCommand = new NXTCommand();
    public Motor A;
    public Motor B;
    public Motor C;
    public RemoteBattery Battery;
    public RemoteSensorPort S1;
    public RemoteSensorPort S2;
    public RemoteSensorPort S3;
    public RemoteSensorPort S4;

    public RemoteNXT(String name) throws IOException {
        this.nxtCommand.open(name);
        this.A = new Motor(new RemoteMotorPort(this.nxtCommand, 0));
        this.A.regulateSpeed(false);
        this.A.shutdown();
        this.B = new Motor(new RemoteMotorPort(this.nxtCommand, 1));
        this.B.regulateSpeed(false);
        this.B.shutdown();
        this.C = new Motor(new RemoteMotorPort(this.nxtCommand, 2));
        this.C.regulateSpeed(false);
        this.C.shutdown();
        this.Battery = new RemoteBattery(this.nxtCommand);
        this.S1 = new RemoteSensorPort(this.nxtCommand, 0);
        this.S2 = new RemoteSensorPort(this.nxtCommand, 1);
        this.S3 = new RemoteSensorPort(this.nxtCommand, 2);
        this.S4 = new RemoteSensorPort(this.nxtCommand, 3);
    }

    public String getBrickName() {
        try {
            DeviceInfo i = this.nxtCommand.getDeviceInfo();
            return i.NXTname;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public String getBluetoothAddress() {
        try {
            DeviceInfo i = this.nxtCommand.getDeviceInfo();
            return i.bluetoothAddress;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public int getFlashMemory() {
        try {
            DeviceInfo i = this.nxtCommand.getDeviceInfo();
            return i.freeFlash;
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    public String getFirmwareVersion() {
        try {
            FirmwareInfo f = this.nxtCommand.getFirmwareVersion();
            return f.firmwareVersion;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public String getProtocolVersion() {
        try {
            FirmwareInfo f = this.nxtCommand.getFirmwareVersion();
            return f.protocolVersion;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public byte deleteFlashMemory() {
        try {
            return this.nxtCommand.deleteUserFlash();
        }
        catch (IOException ioe) {
            return -1;
        }
    }
}

