/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.BluetoothStackBlueSoleil;
import com.intel.bluetooth.BluetoothStackMicrosoft;
import com.intel.bluetooth.BluetoothStackOSX;
import com.intel.bluetooth.BluetoothStackToshiba;
import com.intel.bluetooth.BluetoothStackWIDCOMM;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.NativeLibLoader;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.UtilsJavaSE;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;

public class BlueCoveImpl {
    public static final int versionMajor1 = 2;
    public static final int versionMajor2 = 0;
    public static final int versionMinor = 2;
    public static final int versionBuild = 77;
    public static final String versionSufix = "";
    public static final String version = String.valueOf(2) + "." + String.valueOf(0) + "." + String.valueOf(2) + "";
    private static final int nativeLibraryVersionExpected = 2000277;
    public static final String STACK_WINSOCK = "winsock";
    public static final String STACK_WIDCOMM = "widcomm";
    public static final String STACK_BLUESOLEIL = "bluesoleil";
    public static final String STACK_TOSHIBA = "toshiba";
    public static final String STACK_BLUEZ = "bluez";
    public static final String STACK_OSX = "mac";
    private static final boolean oneDLLbuild = false;
    public static final String NATIVE_LIB_MS = "intelbth";
    public static final String NATIVE_LIB_WIDCOMM = "bluecove";
    public static final String NATIVE_LIB_TOSHIBA = "bluecove";
    public static final String NATIVE_LIB_BLUEZ = "bluecove";
    public static final String NATIVE_LIB_OSX = "bluecove";
    public static final String NATIVE_LIB_BLUESOLEIL = "intelbth";
    private BluetoothStack bluetoothStack;
    private static final int BLUECOVE_STACK_DETECT_MICROSOFT = 1;
    private static final int BLUECOVE_STACK_DETECT_WIDCOMM = 2;
    private static final int BLUECOVE_STACK_DETECT_BLUESOLEIL = 4;
    private static final int BLUECOVE_STACK_DETECT_TOSHIBA = 8;
    private static final int BLUECOVE_STACK_DETECT_OSX = 16;
    private static final int BLUECOVE_STACK_DETECT_BLUEZ = 32;
    private static Hashtable configProperty = new Hashtable();
    private static final String FQCN = (class$com$intel$bluetooth$BlueCoveImpl == null ? (class$com$intel$bluetooth$BlueCoveImpl = BlueCoveImpl.class$("com.intel.bluetooth.BlueCoveImpl")) : class$com$intel$bluetooth$BlueCoveImpl).getName();
    private static final Vector fqcnSet = new Vector();
    private Object accessControlContext;
    private boolean shutdownHookCreated;
    private static BlueCoveImpl instance;
    static /* synthetic */ Class class$com$intel$bluetooth$BlueCoveImpl;
    static /* synthetic */ Class class$com$intel$bluetooth$DebugLog;

    public static synchronized BlueCoveImpl instance() {
        if (instance == null) {
            instance = new BlueCoveImpl();
        }
        return instance;
    }

    private BlueCoveImpl() {
        try {
            this.accessControlContext = AccessController.getContext();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DebugLog.isDebugEnabled();
    }

    private synchronized void createShutdownHook() {
        if (this.shutdownHookCreated) {
            return;
        }
        this.shutdownHookCreated = true;
        AsynchronousShutdownThread shutdownHookThread = new AsynchronousShutdownThread();
        UtilsJavaSE.threadSetDaemon(shutdownHookThread);
        shutdownHookThread.start();
        try {
            UtilsJavaSE.runtimeAddShutdownHook(new ShutdownHookThread(shutdownHookThread.monitor));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int getStackId(String stack) {
        if (STACK_WIDCOMM.equalsIgnoreCase(stack)) {
            return 2;
        }
        if (STACK_BLUESOLEIL.equalsIgnoreCase(stack)) {
            return 4;
        }
        if (STACK_TOSHIBA.equalsIgnoreCase(stack)) {
            return 8;
        }
        if (STACK_WINSOCK.equalsIgnoreCase(stack)) {
            return 1;
        }
        if (STACK_BLUEZ.equalsIgnoreCase(stack)) {
            return 32;
        }
        if (STACK_WINSOCK.equalsIgnoreCase(stack)) {
            return 16;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void detectStack() throws BluetoothStateException {
        String stackSelected;
        BluetoothStack detectorStack;
        block19: {
            block20: {
                int aval;
                block23: {
                    block22: {
                        block21: {
                            detectorStack = null;
                            String stackFirstDetector = BlueCoveImpl.getConfigProperty("bluecove.stack.first");
                            stackSelected = BlueCoveImpl.getConfigProperty("bluecove.stack");
                            if (stackFirstDetector == null) {
                                stackFirstDetector = stackSelected;
                            }
                            switch (NativeLibLoader.getOS()) {
                                case 1: {
                                    if (!NativeLibLoader.isAvailable("bluecove")) {
                                        throw new BluetoothStateException("BlueCove not available");
                                    }
                                    String className = BlueCoveImpl.getConfigProperty("bluecove.bluez.class");
                                    if (className == null) {
                                        className = "com.intel.bluetooth.BluetoothStackBlueZ";
                                    }
                                    try {
                                        Class<?> c = Class.forName(className);
                                        detectorStack = (BluetoothStack)c.newInstance();
                                    }
                                    catch (ClassNotFoundException e) {
                                        DebugLog.error(className, e);
                                    }
                                    catch (InstantiationException e) {
                                        DebugLog.error(className, e);
                                    }
                                    catch (IllegalAccessException e) {
                                        DebugLog.error(className, e);
                                    }
                                    stackSelected = detectorStack.getStackID();
                                    break;
                                }
                                case 4: {
                                    if (!NativeLibLoader.isAvailable("bluecove")) {
                                        throw new BluetoothStateException("BlueCove not available");
                                    }
                                    detectorStack = new BluetoothStackOSX();
                                    stackSelected = detectorStack.getStackID();
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    detectorStack = this.createDetectorOnWindows(stackFirstDetector);
                                    if (!DebugLog.isDebugEnabled()) break;
                                    detectorStack.enableNativeDebug(class$com$intel$bluetooth$DebugLog == null ? (class$com$intel$bluetooth$DebugLog = BlueCoveImpl.class$("com.intel.bluetooth.DebugLog")) : class$com$intel$bluetooth$DebugLog, true);
                                    break;
                                }
                                default: {
                                    throw new BluetoothStateException("BlueCove not available");
                                }
                            }
                            int libraryVersion = detectorStack.getLibraryVersion();
                            if (2000277 != libraryVersion) {
                                DebugLog.fatal("BlueCove native library version mismatch " + libraryVersion + " expected " + 2000277);
                                return;
                            }
                            if (stackSelected != null) break block20;
                            aval = detectorStack.detectBluetoothStack();
                            DebugLog.debug("BluetoothStack detected", aval);
                            int detectorID = this.getStackId(detectorStack.getStackID());
                            if ((aval & detectorID) == 0) break block21;
                            stackSelected = detectorStack.getStackID();
                            break block19;
                        }
                        if ((aval & 1) == 0) break block22;
                        stackSelected = STACK_WINSOCK;
                        break block19;
                    }
                    if ((aval & 2) == 0) break block23;
                    stackSelected = STACK_WIDCOMM;
                    break block19;
                }
                if ((aval & 4) != 0) {
                    stackSelected = STACK_BLUESOLEIL;
                    break block19;
                } else if ((aval & 8) != 0) {
                    stackSelected = STACK_TOSHIBA;
                    break block19;
                } else {
                    if ((aval & 0x10) == 0) {
                        DebugLog.fatal("BluetoothStack not detected");
                        throw new BluetoothStateException("BluetoothStack not detected");
                    }
                    stackSelected = STACK_OSX;
                }
                break block19;
            }
            DebugLog.debug("BluetoothStack selected", stackSelected);
        }
        stackSelected = this.setBluetoothStack(stackSelected, detectorStack);
        this.copySystemProperty();
        System.out.println("BlueCove version " + version + " on " + stackSelected);
    }

    public static void setConfigProperty(String key, String value) {
        if (instance != null) {
            throw new IllegalArgumentException("BlueCove Stack already initialized");
        }
        if (value == null) {
            configProperty.remove(key);
        } else {
            configProperty.put(key, value);
        }
    }

    static String getConfigProperty(String key) {
        String value = (String)configProperty.get(key);
        if (value == null) {
            try {
                value = System.getProperty(key);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (value == null) {
            value = Utils.getResourceProperty(class$com$intel$bluetooth$BlueCoveImpl == null ? (class$com$intel$bluetooth$BlueCoveImpl = BlueCoveImpl.class$("com.intel.bluetooth.BlueCoveImpl")) : class$com$intel$bluetooth$BlueCoveImpl, key);
        }
        return value;
    }

    void copySystemProperty() {
        if (this.bluetoothStack != null) {
            UtilsJavaSE.setSystemProperty("bluetooth.api.version", "1.1");
            UtilsJavaSE.setSystemProperty("obex.api.version", "1.1");
            String[] property = new String[]{"bluetooth.master.switch", "bluetooth.sd.attr.retrievable.max", "bluetooth.connected.devices.max", "bluetooth.l2cap.receiveMTU.max", "bluetooth.sd.trans.max", "bluetooth.connected.inquiry.scan", "bluetooth.connected.page.scan", "bluetooth.connected.inquiry", "bluetooth.connected.page"};
            for (int i = 0; i < property.length; ++i) {
                UtilsJavaSE.setSystemProperty(property[i], this.bluetoothStack.getLocalDeviceProperty(property[i]));
            }
        }
    }

    private BluetoothStack createDetectorOnWindows(String stackFirst) throws BluetoothStateException {
        if (stackFirst != null) {
            DebugLog.debug("detector stack", stackFirst);
            if (STACK_WIDCOMM.equalsIgnoreCase(stackFirst)) {
                if (NativeLibLoader.isAvailable("bluecove")) {
                    return new BluetoothStackWIDCOMM();
                }
            } else if (STACK_BLUESOLEIL.equalsIgnoreCase(stackFirst)) {
                if (NativeLibLoader.isAvailable("intelbth")) {
                    return new BluetoothStackBlueSoleil();
                }
            } else if (STACK_WINSOCK.equalsIgnoreCase(stackFirst)) {
                if (NativeLibLoader.isAvailable("intelbth")) {
                    return new BluetoothStackMicrosoft();
                }
            } else if (STACK_TOSHIBA.equalsIgnoreCase(stackFirst)) {
                if (NativeLibLoader.isAvailable("bluecove")) {
                    return new BluetoothStackToshiba();
                }
            } else {
                throw new IllegalArgumentException("Invalid BlueCove detector stack [" + stackFirst + "]");
            }
        }
        if (NativeLibLoader.isAvailable("intelbth")) {
            return new BluetoothStackMicrosoft();
        }
        if (NativeLibLoader.isAvailable("bluecove")) {
            return new BluetoothStackWIDCOMM();
        }
        throw new BluetoothStateException("BlueCove not available");
    }

    public String setBluetoothStack(String stack) throws BluetoothStateException {
        return this.setBluetoothStack(stack, null);
    }

    private synchronized String setBluetoothStack(String stack, BluetoothStack detectorStack) throws BluetoothStateException {
        Object newStack;
        int libraryVersion;
        if (this.bluetoothStack != null) {
            this.bluetoothStack.destroy();
            this.bluetoothStack = null;
        }
        if (2000277 != (libraryVersion = (newStack = detectorStack != null && detectorStack.getStackID().equalsIgnoreCase(stack) ? detectorStack : (STACK_WIDCOMM.equalsIgnoreCase(stack) ? new BluetoothStackWIDCOMM() : (STACK_BLUESOLEIL.equalsIgnoreCase(stack) ? new BluetoothStackBlueSoleil() : (STACK_TOSHIBA.equalsIgnoreCase(stack) ? new BluetoothStackToshiba() : new BluetoothStackMicrosoft())))).getLibraryVersion())) {
            DebugLog.fatal("BlueCove native library version mismatch " + libraryVersion + " expected " + 2000277);
            return null;
        }
        if (DebugLog.isDebugEnabled()) {
            newStack.enableNativeDebug(class$com$intel$bluetooth$DebugLog == null ? (class$com$intel$bluetooth$DebugLog = BlueCoveImpl.class$("com.intel.bluetooth.DebugLog")) : class$com$intel$bluetooth$DebugLog, true);
        }
        newStack.initialize();
        this.createShutdownHook();
        this.bluetoothStack = newStack;
        return this.bluetoothStack.getStackID();
    }

    public void enableNativeDebug(boolean on) {
        if (this.bluetoothStack != null) {
            this.bluetoothStack.enableNativeDebug(class$com$intel$bluetooth$DebugLog == null ? (class$com$intel$bluetooth$DebugLog = BlueCoveImpl.class$("com.intel.bluetooth.DebugLog")) : class$com$intel$bluetooth$DebugLog, on);
        }
    }

    public synchronized BluetoothStack getBluetoothStack() throws BluetoothStateException {
        Utils.isLegalAPICall(fqcnSet);
        if (this.bluetoothStack == null) {
            if (this.accessControlContext == null) {
                this.detectStack();
            } else {
                this.detectStackPrivileged();
            }
            if (this.bluetoothStack == null) {
                throw new BluetoothStateException("BlueCove not available");
            }
        }
        return this.bluetoothStack;
    }

    private void detectStackPrivileged() throws BluetoothStateException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BluetoothStateException {
                    BlueCoveImpl.this.detectStack();
                    return null;
                }
            }, (AccessControlContext)this.accessControlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (BluetoothStateException)e.getCause();
            }
            throw new BluetoothStateException(e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fqcnSet.addElement(FQCN);
    }

    private class ShutdownHookThread
    extends Thread {
        private Object monitor;

        ShutdownHookThread(Object monitor) {
            super("BluecoveShutdownHookThread");
            this.monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
                if (BlueCoveImpl.this.bluetoothStack != null) {
                    try {
                        this.monitor.wait(7000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class AsynchronousShutdownThread
    extends Thread {
        Object monitor = new Object();

        AsynchronousShutdownThread() {
            super("BluecoveAsynchronousShutdownThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.monitor;
            synchronized (object) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (BlueCoveImpl.this.bluetoothStack != null) {
                BlueCoveImpl.this.bluetoothStack.destroy();
                BlueCoveImpl.this.bluetoothStack = null;
            }
            System.out.println("BlueCove stack shutdown completed");
            object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
    }
}

