/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.UtilsJavaSE;
import java.util.Hashtable;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.UUID;

class SearchServicesThread
extends Thread {
    private static int transIDGenerator = 0;
    private static Hashtable threads = new Hashtable();
    private SearchServicesRunnable stack;
    private int transID;
    private int[] attrSet;
    UUID[] uuidSet;
    RemoteDevice device;
    private DiscoveryListener listener;
    private BluetoothStateException startException;
    private boolean started = false;
    private boolean finished = false;
    private boolean terminated = false;
    private Object serviceSearchStartedEvent = new Object();

    private SearchServicesThread(SearchServicesRunnable stack, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) {
        super("SearchServicesThread");
        this.stack = stack;
        this.transID = ++transIDGenerator;
        this.attrSet = attrSet;
        this.listener = listener;
        this.uuidSet = uuidSet;
        this.device = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int startSearchServices(SearchServicesRunnable stack, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        SearchServicesThread t = new SearchServicesThread(stack, attrSet, uuidSet, device, listener);
        UtilsJavaSE.threadSetDaemon(t);
        Object object = t.serviceSearchStartedEvent;
        synchronized (object) {
            t.start();
            while (!t.started && !t.finished) {
                try {
                    t.serviceSearchStartedEvent.wait();
                }
                catch (InterruptedException e) {
                    return 0;
                }
                if (t.startException == null) continue;
                throw t.startException;
            }
        }
        if (t.started) {
            threads.put(new Integer(t.getTransID()), t);
            return t.getTransID();
        }
        throw new BluetoothStateException();
    }

    static SearchServicesThread getServiceSearchThread(int transID) {
        return (SearchServicesThread)threads.get(new Integer(transID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int respCode = 3;
        try {
            respCode = this.stack.runSearchServices(this, this.attrSet, this.uuidSet, this.device, this.listener);
        }
        catch (BluetoothStateException e) {
            this.startException = e;
            return;
        }
        finally {
            this.finished = true;
            threads.remove(new Integer(this.getTransID()));
            Object object = this.serviceSearchStartedEvent;
            synchronized (object) {
                this.serviceSearchStartedEvent.notifyAll();
            }
            DebugLog.debug("runSearchServices ends", this.getTransID());
            if (this.started) {
                Utils.j2meUsagePatternDellay();
                this.listener.serviceSearchCompleted(this.getTransID(), respCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchServicesStartedCallback() {
        DebugLog.debug("searchServicesStartedCallback", this.getTransID());
        this.started = true;
        Object object = this.serviceSearchStartedEvent;
        synchronized (object) {
            this.serviceSearchStartedEvent.notifyAll();
        }
    }

    int getTransID() {
        return this.transID;
    }

    void setTerminated() {
        this.terminated = true;
        threads.remove(new Integer(this.getTransID()));
    }

    boolean isTerminated() {
        return this.terminated;
    }
}

