/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.DebugLog;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

public class SelectServiceHandler
implements DiscoveryListener {
    private DiscoveryAgent agent;
    private Object inquiryCompletedEvent = new Object();
    private Object serviceSearchCompletedEvent = new Object();
    private Hashtable devicesProcessed = new Hashtable();
    private Vector serviceSearchDeviceQueue = new Vector();
    UUID uuid;
    private ServiceRecord servRecordDiscovered;

    public SelectServiceHandler(DiscoveryAgent agent) {
        this.agent = agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String selectService(UUID uuid, int security, boolean master) throws BluetoothStateException {
        Object sr;
        int i;
        if (uuid == null) {
            throw new NullPointerException("uuid is null");
        }
        switch (security) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        RemoteDevice[] devs = this.agent.retrieveDevices(1);
        for (i = 0; devs != null && i < devs.length; ++i) {
            sr = this.findServiceOnDevice(uuid, devs[i]);
            if (sr == null) continue;
            return sr.getConnectionURL(security, master);
        }
        devs = this.agent.retrieveDevices(0);
        for (i = 0; devs != null && i < devs.length; ++i) {
            sr = this.findServiceOnDevice(uuid, devs[i]);
            if (sr == null) continue;
            return sr.getConnectionURL(security, master);
        }
        this.uuid = uuid;
        ParallelSearchServicesThread t = new ParallelSearchServicesThread();
        t.start();
        sr = this.inquiryCompletedEvent;
        synchronized (sr) {
            if (!this.agent.startInquiry(10390323, this)) {
                return null;
            }
            try {
                this.inquiryCompletedEvent.wait();
            }
            catch (InterruptedException e) {
                return null;
            }
            this.agent.cancelInquiry(this);
        }
        if (this.servRecordDiscovered == null && !t.processedAll()) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        t.interrupt();
        if (this.servRecordDiscovered != null) {
            return this.servRecordDiscovered.getConnectionURL(security, master);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRecord findServiceOnDevice(UUID uuid, RemoteDevice device) {
        if (this.devicesProcessed.containsKey(device)) {
            return null;
        }
        this.devicesProcessed.put(device, device);
        DebugLog.debug("searchServices on ", device);
        Object object = this.serviceSearchCompletedEvent;
        synchronized (object) {
            try {
                this.agent.searchServices(null, new UUID[]{uuid}, device, this);
            }
            catch (BluetoothStateException e) {
                DebugLog.error("searchServices", e);
            }
            try {
                this.serviceSearchCompletedEvent.wait();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return this.servRecordDiscovered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if (this.devicesProcessed.containsKey(btDevice)) {
            return;
        }
        Vector vector = this.serviceSearchDeviceQueue;
        synchronized (vector) {
            this.serviceSearchDeviceQueue.add(btDevice);
            this.serviceSearchDeviceQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int discType) {
        Object object = this.inquiryCompletedEvent;
        synchronized (object) {
            this.inquiryCompletedEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int transID, int respCode) {
        Object object = this.serviceSearchCompletedEvent;
        synchronized (object) {
            this.serviceSearchCompletedEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        if (servRecord.length > 0 && this.servRecordDiscovered == null) {
            this.servRecordDiscovered = servRecord[0];
            Object object = this.inquiryCompletedEvent;
            synchronized (object) {
                this.inquiryCompletedEvent.notifyAll();
            }
        }
    }

    private class ParallelSearchServicesThread
    extends Thread {
        boolean stoped = false;
        int processedNext = 0;
        int processedSize = 0;

        private ParallelSearchServicesThread() {
        }

        boolean processedAll() {
            return this.processedNext == SelectServiceHandler.this.serviceSearchDeviceQueue.size();
        }

        public void interrupt() {
            this.stoped = true;
            super.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block5: while (!this.stoped && SelectServiceHandler.this.servRecordDiscovered == null) {
                Vector vector = SelectServiceHandler.this.serviceSearchDeviceQueue;
                synchronized (vector) {
                    if (this.processedSize == SelectServiceHandler.this.serviceSearchDeviceQueue.size()) {
                        try {
                            SelectServiceHandler.this.serviceSearchDeviceQueue.wait();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    this.processedSize = SelectServiceHandler.this.serviceSearchDeviceQueue.size();
                }
                for (int i = this.processedNext; i < this.processedSize; ++i) {
                    RemoteDevice btDevice = (RemoteDevice)SelectServiceHandler.this.serviceSearchDeviceQueue.elementAt(i);
                    if (SelectServiceHandler.this.findServiceOnDevice(SelectServiceHandler.this.uuid, btDevice) != null) break block5;
                }
                this.processedNext = this.processedSize + 1;
            }
        }
    }
}

