/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.obex.OBEXClientSessionImpl;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.HeaderSet;
import javax.obex.Operation;

abstract class OBEXClientOperation
implements Operation {
    protected OBEXClientSessionImpl session;
    protected HeaderSet replyHeaders;
    protected HeaderSet sendHeaders;
    protected int sendHeadersLength = 0;
    protected boolean isClosed;
    protected boolean operationInProgress;
    protected boolean operationStarted;
    protected boolean outputStreamOpened = false;
    protected boolean inputStreamOpened = false;
    protected Object lock;

    OBEXClientOperation(OBEXClientSessionImpl session, HeaderSet replyHeaders) throws IOException {
        this.session = session;
        this.replyHeaders = replyHeaders;
        this.isClosed = false;
        this.lock = new Object();
        if (replyHeaders != null) {
            switch (replyHeaders.getResponseCode()) {
                case 144: 
                case 160: {
                    this.operationInProgress = true;
                    break;
                }
                default: {
                    this.operationInProgress = false;
                    break;
                }
            }
        } else {
            this.operationInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeAbort() throws IOException {
        try {
            this.session.writeOperation(255, null);
            byte[] b = this.session.readOperation();
            OBEXHeaderSetImpl dataHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
            if (dataHeaders.getResponseCode() != 160) {
                throw new IOException("Fails to abort operation");
            }
        }
        finally {
            this.isClosed = true;
            this.closeStream();
        }
    }

    abstract void started() throws IOException;

    abstract void closeStream() throws IOException;

    protected void validateOperationIsOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("operation closed");
        }
    }

    public HeaderSet getReceivedHeaders() throws IOException {
        this.validateOperationIsOpen();
        this.started();
        return OBEXHeaderSetImpl.cloneHeaders(this.replyHeaders);
    }

    public int getResponseCode() throws IOException {
        this.validateOperationIsOpen();
        this.started();
        this.closeStream();
        return this.replyHeaders.getResponseCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeaders(HeaderSet headers) throws IOException {
        if (headers == null) {
            throw new NullPointerException("headers are null");
        }
        OBEXHeaderSetImpl.validateCreatedHeaderSet(headers);
        this.validateOperationIsOpen();
        if (this.operationStarted && !this.operationInProgress) {
            throw new IOException("the transaction has already ended");
        }
        Object object = this.lock;
        synchronized (object) {
            this.sendHeaders = headers;
            this.sendHeadersLength = OBEXHeaderSetImpl.toByteArray(this.sendHeaders).length;
        }
    }

    public String getEncoding() {
        return null;
    }

    public long getLength() {
        Long len;
        try {
            len = (Long)this.replyHeaders.getHeader(195);
        }
        catch (IOException e) {
            return -1L;
        }
        if (len == null) {
            return -1L;
        }
        return len;
    }

    public String getType() {
        try {
            return (String)this.replyHeaders.getHeader(66);
        }
        catch (IOException e) {
            return null;
        }
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public void close() throws IOException {
        this.started();
        this.closeStream();
        if (!this.isClosed) {
            this.isClosed = true;
            DebugLog.debug("operation closed");
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public abstract /* synthetic */ void abort() throws IOException;

    public abstract /* synthetic */ InputStream openInputStream() throws IOException;

    public abstract /* synthetic */ OutputStream openOutputStream() throws IOException;
}

