/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.obex.OBEXClientOperation;
import com.intel.bluetooth.obex.OBEXClientSessionImpl;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXOperationInputStream;
import com.intel.bluetooth.obex.OBEXOperationReceive;
import com.intel.bluetooth.obex.OBEXUtils;
import com.intel.bluetooth.obex.UnsupportedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.HeaderSet;

class OBEXClientOperationGet
extends OBEXClientOperation
implements OBEXOperationReceive {
    private OBEXOperationInputStream inputStream = new OBEXOperationInputStream(this);

    OBEXClientOperationGet(OBEXClientSessionImpl session, HeaderSet replyHeaders) throws IOException {
        super(session, replyHeaders);
        this.processData(replyHeaders, this.inputStream);
    }

    void started() throws IOException {
    }

    public InputStream openInputStream() throws IOException {
        this.validateOperationIsOpen();
        if (this.inputStreamOpened) {
            throw new IOException("input stream already open");
        }
        DebugLog.debug("openInputStream");
        this.inputStreamOpened = true;
        this.operationStarted = true;
        return this.inputStream;
    }

    public void abort() throws IOException {
        this.validateOperationIsOpen();
        if (!this.operationInProgress) {
            throw new IOException("the transaction has already ended");
        }
        this.writeAbort();
    }

    public void closeStream() throws IOException {
        this.operationInProgress = false;
        this.inputStream.close();
    }

    public OutputStream openOutputStream() throws IOException {
        this.validateOperationIsOpen();
        if (this.outputStreamOpened) {
            throw new IOException("output already open");
        }
        this.outputStreamOpened = true;
        return new UnsupportedOutputStream();
    }

    public void receiveData(OBEXOperationInputStream is) throws IOException {
        this.session.writeOperation(131, OBEXHeaderSetImpl.toByteArray(this.sendHeaders));
        byte[] b = this.session.readOperation();
        OBEXHeaderSetImpl dataHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
        switch (dataHeaders.getResponseCode()) {
            case 144: {
                this.processData(dataHeaders, is);
                break;
            }
            case 160: {
                this.processData(dataHeaders, is);
                this.replyHeaders = dataHeaders;
                this.closeStream();
                break;
            }
            default: {
                throw new IOException("Operation error " + OBEXUtils.toStringObexResponseCodes(dataHeaders.getResponseCode()));
            }
        }
    }

    private boolean processData(HeaderSet requestHeaders, OBEXOperationInputStream is) throws IOException {
        byte[] data = (byte[])requestHeaders.getHeader(73);
        if (data == null) {
            data = (byte[])requestHeaders.getHeader(72);
        }
        if (data != null && data.length != 0) {
            DebugLog.debug("processData len", data.length);
            is.appendData(data);
            return true;
        }
        return false;
    }
}

