/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.obex.OBEXClientOperation;
import com.intel.bluetooth.obex.OBEXClientSessionImpl;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXOperationDelivery;
import com.intel.bluetooth.obex.OBEXOperationOutputStream;
import com.intel.bluetooth.obex.OBEXUtils;
import com.intel.bluetooth.obex.UnsupportedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.HeaderSet;

class OBEXClientOperationPut
extends OBEXClientOperation
implements OBEXOperationDelivery {
    protected OBEXOperationOutputStream os;

    OBEXClientOperationPut(OBEXClientSessionImpl session, HeaderSet sendHeaders) throws IOException {
        super(session, null);
        this.sendHeaders = sendHeaders;
    }

    public InputStream openInputStream() throws IOException {
        this.validateOperationIsOpen();
        if (this.inputStreamOpened) {
            throw new IOException("input stream already open");
        }
        this.inputStreamOpened = true;
        this.operationInProgress = true;
        return new UnsupportedInputStream();
    }

    void started() throws IOException {
        if (!this.outputStreamOpened && !this.operationStarted) {
            this.replyHeaders = this.session.deleteImp(this.sendHeaders);
            this.operationStarted = true;
        }
    }

    private void startPutOperation() throws IOException {
        this.operationStarted = true;
        this.session.writeOperation(2, OBEXHeaderSetImpl.toByteArray(this.sendHeaders));
        this.sendHeaders = null;
        byte[] b = this.session.readOperation();
        this.replyHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
        DebugLog.debug0x("PUT got reply", this.replyHeaders.getResponseCode());
        this.operationInProgress = true;
    }

    public OutputStream openOutputStream() throws IOException {
        this.validateOperationIsOpen();
        if (this.outputStreamOpened) {
            throw new IOException("output already open");
        }
        this.outputStreamOpened = true;
        this.startPutOperation();
        this.os = new OBEXOperationOutputStream(this.session.mtu, this);
        return this.os;
    }

    public void sendHeaders(HeaderSet headers) throws IOException {
        super.sendHeaders(headers);
        if (this.os != null) {
            this.os.deliverBuffer(false);
        }
    }

    public void deliverPacket(boolean finalPacket, byte[] buffer) throws IOException {
        int commId = 2;
        int dataHeaderID = 72;
        if (finalPacket) {
            commId |= 0x80;
            dataHeaderID = 73;
        }
        HeaderSet dataHeaders = this.session.createHeaderSet();
        dataHeaders.setHeader(dataHeaderID, buffer);
        if (this.sendHeadersLength + buffer.length + 11 > this.session.mtu) {
            this.session.writeOperation(commId, OBEXHeaderSetImpl.toByteArray(dataHeaders));
        } else {
            this.session.writeOperation(commId, OBEXHeaderSetImpl.toByteArray(this.sendHeaders), OBEXHeaderSetImpl.toByteArray(dataHeaders));
            this.sendHeaders = null;
            this.sendHeadersLength = 0;
        }
        byte[] b = this.session.readOperation();
        this.replyHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
        int responseCode = this.replyHeaders.getResponseCode();
        DebugLog.debug0x("PUT server reply", responseCode);
        switch (responseCode) {
            case 160: {
                this.operationInProgress = false;
                break;
            }
            case 144: {
                break;
            }
            default: {
                if (finalPacket) break;
                throw new IOException("Can't continue connection, 0x" + Integer.toHexString(responseCode) + " " + OBEXUtils.toStringObexResponseCodes(responseCode));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() throws IOException {
        this.validateOperationIsOpen();
        if (!this.operationInProgress) {
            throw new IOException("the transaction has already ended");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.os != null) {
                this.os.abort();
            }
        }
        this.writeAbort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStream() throws IOException {
        this.operationInProgress = false;
        if (this.os != null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.os != null) {
                    this.os.close();
                }
                this.os = null;
            }
        }
    }
}

