/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXOperationInputStream;
import com.intel.bluetooth.obex.OBEXOperationReceive;
import com.intel.bluetooth.obex.OBEXServerOperation;
import com.intel.bluetooth.obex.OBEXServerSessionImpl;
import com.intel.bluetooth.obex.UnsupportedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.HeaderSet;

class OBEXServerOperationPut
extends OBEXServerOperation
implements OBEXOperationReceive {
    private OBEXOperationInputStream inputStream = new OBEXOperationInputStream(this);
    private boolean inputStreamOpened = false;

    protected OBEXServerOperationPut(OBEXServerSessionImpl session, HeaderSet receivedHeaders, boolean finalPacket) throws IOException {
        super(session, receivedHeaders);
        this.processData(receivedHeaders, this.inputStream);
    }

    public InputStream openInputStream() throws IOException {
        if (this.isClosed) {
            throw new IOException("operation closed");
        }
        if (this.inputStreamOpened) {
            throw new IOException("input stream already open");
        }
        DebugLog.debug("openInputStream");
        this.inputStreamOpened = true;
        this.session.writeOperation(144, OBEXHeaderSetImpl.toByteArray(this.sendHeaders));
        return this.inputStream;
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.isClosed) {
            throw new IOException("operation closed");
        }
        return new UnsupportedOutputStream();
    }

    public void close() throws IOException {
        DebugLog.debug("server close put");
        this.inputStream.close();
        super.close();
    }

    public void receiveData(OBEXOperationInputStream is) throws IOException {
        boolean finalPacket;
        byte[] b = this.session.readOperation();
        int opcode = b[0] & 0xFF;
        boolean bl = finalPacket = (opcode & 0x80) != 0;
        if (finalPacket) {
            DebugLog.debug("OBEXServerSession operation final packet");
            this.finalPacketReceived = true;
        }
        switch (opcode) {
            case 2: 
            case 130: {
                OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
                this.processRequest(requestHeaders, finalPacket, is);
                break;
            }
            case 255: {
                this.processAbort();
                break;
            }
            default: {
                this.session.writeOperation(209, null);
            }
        }
    }

    private void processAbort() throws IOException {
        this.session.writeOperation(160, null);
        this.close();
        throw new IOException("Operation aborted by client");
    }

    private boolean processData(HeaderSet requestHeaders, OBEXOperationInputStream is) throws IOException {
        byte[] data = (byte[])requestHeaders.getHeader(73);
        if (data == null) {
            data = (byte[])requestHeaders.getHeader(72);
        }
        if (data != null && data.length != 0 && is != null) {
            DebugLog.debug("processData len", data.length);
            is.appendData(data);
            return true;
        }
        return false;
    }

    protected void processRequest(HeaderSet requestHeaders, boolean finalPacket, OBEXOperationInputStream is) throws IOException {
        this.processData(requestHeaders, is);
        if (finalPacket) {
            DebugLog.debug("put got final packet");
            this.close();
        } else {
            DebugLog.debug("reply continue");
            this.session.writeOperation(144, OBEXHeaderSetImpl.toByteArray(this.sendHeaders));
        }
    }

    void writeResponse(int responseCode) throws IOException {
        this.session.writeOperation(responseCode, OBEXHeaderSetImpl.toByteArray(this.sendHeaders));
        if (responseCode == 160) {
            while (!this.finalPacketReceived && !this.isClosed()) {
                DebugLog.debug("receive final packet");
                this.receiveData(null);
                if (!this.finalPacketReceived) continue;
                this.session.writeOperation(responseCode, OBEXHeaderSetImpl.toByteArray(this.sendHeaders));
            }
        } else {
            DebugLog.debug("sent final reply");
        }
    }
}

