/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.obex.OBEXConnectionParams;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;

abstract class OBEXUtils {
    OBEXUtils() {
    }

    static void readFully(InputStream is, OBEXConnectionParams obexConnectionParams, byte[] b) throws IOException, EOFException {
        OBEXUtils.readFully(is, obexConnectionParams, b, 0, b.length);
    }

    static void readFully(InputStream is, OBEXConnectionParams obexConnectionParams, byte[] b, int off, int len) throws IOException, EOFException {
        int rc;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int got = 0; got < len; got += rc) {
            if (obexConnectionParams.timeouts) {
                long endOfDellay = System.currentTimeMillis() + (long)obexConnectionParams.timeout;
                int available = 0;
                do {
                    if ((available = is.available()) != 0) continue;
                    if (System.currentTimeMillis() > endOfDellay) {
                        throw new InterruptedIOException("OBEX read timeout");
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                } while (available == 0);
            }
            if ((rc = is.read(b, off + got, len - got)) >= 0) continue;
            throw new EOFException();
        }
    }

    static String newStringUTF16Simple(byte[] bytes) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; i += 2) {
            buf.append((char)OBEXUtils.bytesToShort(bytes[i], bytes[i + 1]));
        }
        return buf.toString();
    }

    static String newStringUTF16(byte[] bytes) throws UnsupportedEncodingException {
        try {
            return new String(bytes, "UTF-16BE");
        }
        catch (IllegalArgumentException e) {
            return OBEXUtils.newStringUTF16Simple(bytes);
        }
        catch (UnsupportedEncodingException e) {
            return OBEXUtils.newStringUTF16Simple(bytes);
        }
    }

    static byte[] getUTF16BytesSimple(String str) throws UnsupportedEncodingException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            buf.write(OBEXUtils.hiByte(c));
            buf.write(OBEXUtils.loByte(c));
        }
        return buf.toByteArray();
    }

    static byte[] getUTF16Bytes(String str) throws UnsupportedEncodingException {
        try {
            return str.getBytes("UTF-16BE");
        }
        catch (IllegalArgumentException e) {
            return OBEXUtils.getUTF16BytesSimple(str);
        }
        catch (UnsupportedEncodingException e) {
            return OBEXUtils.getUTF16BytesSimple(str);
        }
    }

    static byte hiByte(int value) {
        return (byte)(value >> 8 & 0xFF);
    }

    static byte loByte(int value) {
        return (byte)(0xFF & value);
    }

    static int bytesToShort(byte valueHi, byte valueLo) {
        return (valueHi << 8 & 0xFF00) + (valueLo & 0xFF);
    }

    public static String toStringObexResponseCodes(byte code) {
        return OBEXUtils.toStringObexResponseCodes(code & 0xFF);
    }

    public static String toStringObexResponseCodes(int code) {
        switch (code) {
            case 144: {
                return "OBEX_RESPONSE_CONTINUE";
            }
            case 160: {
                return "OBEX_HTTP_OK";
            }
            case 161: {
                return "OBEX_HTTP_CREATED";
            }
            case 162: {
                return "OBEX_HTTP_ACCEPTED";
            }
            case 163: {
                return "OBEX_HTTP_NOT_AUTHORITATIVE";
            }
            case 164: {
                return "OBEX_HTTP_NO_CONTENT";
            }
            case 165: {
                return "OBEX_HTTP_RESET";
            }
            case 166: {
                return "OBEX_HTTP_PARTIAL";
            }
            case 176: {
                return "OBEX_HTTP_MULT_CHOICE";
            }
            case 177: {
                return "OBEX_HTTP_MOVED_PERM";
            }
            case 178: {
                return "OBEX_HTTP_MOVED_TEMP";
            }
            case 179: {
                return "OBEX_HTTP_SEE_OTHER";
            }
            case 180: {
                return "OBEX_HTTP_NOT_MODIFIED";
            }
            case 181: {
                return "OBEX_HTTP_USE_PROXY";
            }
            case 192: {
                return "OBEX_HTTP_BAD_REQUEST";
            }
            case 193: {
                return "OBEX_HTTP_UNAUTHORIZED";
            }
            case 194: {
                return "OBEX_HTTP_PAYMENT_REQUIRED";
            }
            case 195: {
                return "OBEX_HTTP_FORBIDDEN";
            }
            case 196: {
                return "OBEX_HTTP_NOT_FOUND";
            }
            case 197: {
                return "OBEX_HTTP_BAD_METHOD";
            }
            case 198: {
                return "OBEX_HTTP_NOT_ACCEPTABLE";
            }
            case 199: {
                return "OBEX_HTTP_PROXY_AUTH";
            }
            case 200: {
                return "OBEX_HTTP_TIMEOUT";
            }
            case 201: {
                return "OBEX_HTTP_CONFLICT";
            }
            case 202: {
                return "OBEX_HTTP_GONE";
            }
            case 203: {
                return "OBEX_HTTP_LENGTH_REQUIRED";
            }
            case 204: {
                return "OBEX_HTTP_PRECON_FAILED";
            }
            case 205: {
                return "OBEX_HTTP_ENTITY_TOO_LARGE";
            }
            case 206: {
                return "OBEX_HTTP_REQ_TOO_LARGE";
            }
            case 207: {
                return "OBEX_HTTP_UNSUPPORTED_TYPE";
            }
            case 208: {
                return "OBEX_HTTP_INTERNAL_ERROR";
            }
            case 209: {
                return "OBEX_HTTP_NOT_IMPLEMENTED";
            }
            case 210: {
                return "OBEX_HTTP_BAD_GATEWAY";
            }
            case 211: {
                return "OBEX_HTTP_UNAVAILABLE";
            }
            case 212: {
                return "OBEX_HTTP_GATEWAY_TIMEOUT";
            }
            case 213: {
                return "OBEX_HTTP_VERSION";
            }
            case 224: {
                return "OBEX_DATABASE_FULL";
            }
            case 225: {
                return "OBEX_DATABASE_LOCKED";
            }
        }
        return "Unknown 0x" + Integer.toHexString(code);
    }
}

