/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.FileVisitor;
import net.sf.antcontrib.cpptasks.TargetInfo;
import net.sf.antcontrib.cpptasks.compiler.LinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.ProcessorConfiguration;
import org.apache.tools.ant.BuildException;

public final class TargetMatcher
implements FileVisitor {
    private LinkerConfiguration linker;
    private Vector objectFiles;
    private File outputDir;
    private ProcessorConfiguration[] processors;
    private final File[] sourceFiles = new File[1];
    private Hashtable targets;
    private CCTask task;

    public TargetMatcher(CCTask task, File outputDir, ProcessorConfiguration[] processors, LinkerConfiguration linker, Vector objectFiles, Hashtable targets) {
        this.task = task;
        this.outputDir = outputDir;
        this.processors = processors;
        this.targets = targets;
        this.linker = linker;
        this.objectFiles = objectFiles;
    }

    public void visit(File parentDir, String filename) throws BuildException {
        ProcessorConfiguration selectedCompiler = null;
        int bid = 0;
        if (this.processors != null) {
            for (int k = 0; k < this.processors.length; ++k) {
                int newBid = this.processors[k].bid(filename);
                if (newBid <= bid) continue;
                bid = newBid;
                selectedCompiler = this.processors[k];
            }
        }
        if (bid <= 0) {
            int linkerbid;
            if (this.linker != null && (linkerbid = this.linker.bid(filename)) > 0) {
                File objFile = new File(parentDir, filename);
                this.objectFiles.addElement(objFile);
                if (linkerbid == 1) {
                    this.task.log("Unrecognized file type " + objFile.toString() + " will be passed to linker");
                }
            }
        } else {
            String outputFileName = selectedCompiler.getOutputFileName(filename);
            if (outputFileName != null) {
                this.sourceFiles[0] = new File(parentDir, filename);
                TargetInfo previousTarget = (TargetInfo)this.targets.get(outputFileName);
                if (previousTarget == null) {
                    this.targets.put(outputFileName, new TargetInfo(selectedCompiler, this.sourceFiles, null, new File(this.outputDir, outputFileName), selectedCompiler.getRebuild()));
                } else if (!previousTarget.getSources()[0].equals(this.sourceFiles[0])) {
                    StringBuffer builder = new StringBuffer("Output filename conflict: ");
                    builder.append(outputFileName);
                    builder.append(" would be produced from ");
                    builder.append(previousTarget.getSources()[0].toString());
                    builder.append(" and ");
                    builder.append(filename);
                    throw new BuildException(builder.toString());
                }
            }
        }
    }
}

