/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.compiler;

import java.io.File;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CompilerParam;
import net.sf.antcontrib.cpptasks.DependencyInfo;
import net.sf.antcontrib.cpptasks.ProcessorParam;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompiler;
import net.sf.antcontrib.cpptasks.compiler.CompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.PrecompilingCompiler;
import net.sf.antcontrib.cpptasks.compiler.ProgressMonitor;
import org.apache.tools.ant.BuildException;

public final class CommandLineCompilerConfiguration
implements CompilerConfiguration {
    private String[] args;
    private CommandLineCompiler compiler;
    private String[] endArgs;
    private File[] envIncludePath;
    private String[] exceptFiles;
    private String identifier;
    private File[] includePath;
    private String includePathIdentifier;
    private boolean isPrecompiledHeaderGeneration;
    private ProcessorParam[] params;
    private boolean rebuild;
    private File[] sysIncludePath;

    public CommandLineCompilerConfiguration(CommandLineCompiler compiler, String identifier, File[] includePath, File[] sysIncludePath, File[] envIncludePath, String includePathIdentifier, String[] args, ProcessorParam[] params, boolean rebuild, String[] endArgs) {
        if (compiler == null) {
            throw new NullPointerException("compiler");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier");
        }
        if (includePathIdentifier == null) {
            throw new NullPointerException("includePathIdentifier");
        }
        this.args = args == null ? new String[0] : (String[])args.clone();
        this.includePath = includePath == null ? new File[0] : (File[])includePath.clone();
        this.sysIncludePath = sysIncludePath == null ? new File[0] : (File[])sysIncludePath.clone();
        this.envIncludePath = envIncludePath == null ? new File[0] : (File[])envIncludePath.clone();
        this.compiler = compiler;
        this.params = (ProcessorParam[])params.clone();
        this.rebuild = rebuild;
        this.identifier = identifier;
        this.includePathIdentifier = includePathIdentifier;
        this.endArgs = (String[])endArgs.clone();
        this.exceptFiles = null;
        this.isPrecompiledHeaderGeneration = false;
    }

    public CommandLineCompilerConfiguration(CommandLineCompilerConfiguration base, String[] additionalArgs, String[] exceptFiles, boolean isPrecompileHeaderGeneration) {
        this.compiler = base.compiler;
        this.identifier = base.identifier;
        this.rebuild = base.rebuild;
        this.includePath = (File[])base.includePath.clone();
        this.sysIncludePath = (File[])base.sysIncludePath.clone();
        this.endArgs = (String[])base.endArgs.clone();
        this.envIncludePath = (File[])base.envIncludePath.clone();
        this.includePathIdentifier = base.includePathIdentifier;
        if (exceptFiles != null) {
            this.exceptFiles = (String[])exceptFiles.clone();
        }
        this.isPrecompiledHeaderGeneration = isPrecompileHeaderGeneration;
        this.args = new String[base.args.length + additionalArgs.length];
        for (int i = 0; i < base.args.length; ++i) {
            this.args[i] = base.args[i];
        }
        int index = base.args.length;
        for (int i = 0; i < additionalArgs.length; ++i) {
            this.args[index++] = additionalArgs[i];
        }
    }

    public int bid(String inputFile) {
        int compilerBid = this.compiler.bid(inputFile);
        if (compilerBid > 0 && this.exceptFiles != null) {
            for (int i = 0; i < this.exceptFiles.length; ++i) {
                if (!inputFile.equals(this.exceptFiles[i])) continue;
                return 0;
            }
        }
        return compilerBid;
    }

    public void compile(CCTask task, File outputDir, String[] sourceFiles, boolean relentless, ProgressMonitor monitor) throws BuildException {
        if (monitor != null) {
            monitor.start(this);
        }
        try {
            this.compiler.compile(task, outputDir, sourceFiles, this.args, this.endArgs, relentless, this, monitor);
            if (monitor != null) {
                monitor.finish(this, true);
            }
        }
        catch (BuildException ex) {
            if (monitor != null) {
                monitor.finish(this, false);
            }
            throw ex;
        }
    }

    public CompilerConfiguration[] createPrecompileConfigurations(File prototype, String[] nonPrecompiledFiles) {
        if (this.compiler instanceof PrecompilingCompiler) {
            return ((PrecompilingCompiler)((Object)this.compiler)).createPrecompileConfigurations(this, prototype, nonPrecompiledFiles);
        }
        return null;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getIncludePathIdentifier() {
        return this.includePathIdentifier;
    }

    public String getOutputFileName(String inputFile) {
        return this.compiler.getOutputFileName(inputFile);
    }

    public CompilerParam getParam(String name) {
        for (int i = 0; i < this.params.length; ++i) {
            if (!name.equals(this.params[i].getName())) continue;
            return (CompilerParam)this.params[i];
        }
        return null;
    }

    public ProcessorParam[] getParams() {
        return this.params;
    }

    public boolean getRebuild() {
        return this.rebuild;
    }

    public boolean isPrecompileGeneration() {
        return this.isPrecompiledHeaderGeneration;
    }

    public DependencyInfo parseIncludes(CCTask task, File baseDir, File source) {
        return this.compiler.parseIncludes(task, source, this.includePath, this.sysIncludePath, this.envIncludePath, baseDir, this.getIncludePathIdentifier());
    }

    public String toString() {
        return this.identifier;
    }

    public String[] getPreArguments() {
        return (String[])this.args.clone();
    }

    public String[] getEndArguments() {
        return (String[])this.endArgs.clone();
    }
}

