/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import lejos.pc.tools.Connector;

public class DataViewer
extends JFrame
implements ActionListener {
    private JButton startButton = new JButton("Start download");
    private JToggleButton usbButton = new JToggleButton("USE Bluetooth");
    private TextField statusField = new TextField(20);
    private TextField lengthField = new TextField(5);
    private TextField nameField = new TextField(12);
    private int _recordCount = 0;
    private int _rowLength = 4;
    private String _nxt = "NXT";
    private boolean _useUSB = true;
    private DataInputStream dataIn = null;
    private InputStream is = null;
    private OutputStream os = null;
    private Connector con;
    private boolean _connected = false;
    private TextArea theLog;

    public DataViewer() {
        this.setDefaultCloseOperation(3);
        this.setTitle("View Data from NXT Datalogger");
        this.setSize(500, 600);
        JPanel p1 = new JPanel();
        p1.add(new JLabel("Row Length:"));
        p1.add(this.lengthField);
        this.lengthField.setText("2");
        p1.add(new JLabel("name or address"));
        p1.add(this.nameField);
        this.startButton.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.add(this.usbButton);
        this.usbButton.addActionListener(this);
        p2.add(this.startButton);
        p2.add(new JLabel("  Status:"));
        p2.add(this.statusField);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(p1);
        panel.add(p2);
        this.add((Component)panel, "North");
        this.theLog = new TextArea(40, 40);
        this.getContentPane().add((Component)this.theLog, "Center");
        this.statusField.setText("using  USB");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.startButton) {
            this._rowLength = Integer.parseInt(this.lengthField.getText());
            this._nxt = this.nameField.getText();
            this._recordCount = 0;
            this.startDownload();
        }
        if (e.getSource() == this.usbButton) {
            boolean bl = this._useUSB = !this._useUSB;
            if (this._useUSB) {
                this.setMessage("using USB");
            } else {
                this.setMessage("using Bluetooth");
            }
        }
    }

    public static void main(String[] args) {
        DataViewer frame = new DataViewer();
        frame.setVisible(true);
    }

    private void connect() {
        this._nxt = this.nameField.getText();
        this.setMessage("Connecting");
        this.con = new Connector();
        if (!this.con.connectTo(this._nxt, this._useUSB)) {
            System.exit(1);
        }
        this.dataIn = this.con.getDataIn();
        this.is = this.con.getInputStream();
        if (this.dataIn != null) {
            System.out.println(" dataIn OK");
        }
        this.os = this.con.getOutputStream();
        this._connected = true;
    }

    private void startDownload() {
        if (!this._connected) {
            this.connect();
        }
        int b = 15;
        try {
            this.os.write(b);
            this.os.flush();
        }
        catch (IOException e) {
            System.out.println(e + " write ");
        }
        this.setMessage("write " + b);
        this.setMessage("reading");
        float x = 0.0f;
        try {
            int length = this.dataIn.readInt();
            this.setMessage("length " + length);
            for (int i = 0; i < length; ++i) {
                if (0 == this._recordCount % this._rowLength) {
                    this.theLog.append("\n");
                }
                x = this.dataIn.readFloat();
                this.theLog.append(x + "\t ");
                ++this._recordCount;
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public void setMessage(String s) {
        this.statusField.setText(s);
    }
}

