/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import js.tinyvm.TinyVMException;
import lejos.pc.comm.FileInfo;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTCommand;
import lejos.pc.comm.NXTInfo;
import lejos.pc.tools.FileModel;
import lejos.pc.tools.NXJBrowserCommandLineParser;
import lejos.pc.tools.NXTTableModel;
import lejos.pc.tools.SendFile;
import org.apache.commons.cli.CommandLine;

public class NXJBrowser {
    public static final int MAX_FILES = 30;
    private int numFiles;
    private FileInfo[] files = new FileInfo[30];
    private NXTCommand nxtCommand;
    private Cursor hourglassCursor = new Cursor(3);
    private Cursor normalCursor = new Cursor(0);
    private NXJBrowserCommandLineParser fParser = new NXJBrowserCommandLineParser();
    private static String title = "NXJ File Browser";
    private JFrame frame;

    public static void main(String[] args) {
        try {
            NXJBrowser instance = new NXJBrowser();
            instance.run(args);
        }
        catch (Throwable t) {
            System.err.println("Error: " + t.getMessage());
        }
    }

    public void run(String[] args) throws TinyVMException, NXTCommException {
        NXTInfo[] nxts;
        this.frame = new JFrame(title);
        WindowAdapter listener = new WindowAdapter(){

            public void windowClosing(WindowEvent w) {
                try {
                    NXJBrowser.this.nxtCommand.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.exit(0);
            }
        };
        this.frame.addWindowListener(listener);
        this.nxtCommand = NXTCommand.getSingleton();
        CommandLine commandLine = this.fParser.parse(args);
        String name = commandLine.getOptionValue("n");
        boolean blueTooth = commandLine.hasOption("b");
        boolean usb = commandLine.hasOption("u");
        int protocols = 0;
        if (blueTooth) {
            protocols |= 2;
        }
        if (usb) {
            protocols |= 1;
        }
        if (protocols == 0) {
            protocols = 3;
        }
        if ((nxts = this.nxtCommand.search(name, protocols)).length == 0) {
            System.err.println("No NXT found - is it switched on and plugged in (for USB)?");
            System.exit(1);
        }
        NXTTableModel nm = new NXTTableModel(this.frame, nxts, nxts.length);
        final JTable nxtTable = new JTable(nm);
        JScrollPane nxtTablePane = new JScrollPane(nxtTable);
        nxtTable.setRowSelectionInterval(0, 0);
        this.frame.getContentPane().add((Component)nxtTablePane, "Center");
        JButton connectButton = new JButton("Connect");
        connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int row = nxtTable.getSelectedRow();
                if (row >= 0) {
                    boolean open = false;
                    try {
                        open = NXJBrowser.this.nxtCommand.open(nxts[row]);
                    }
                    catch (NXTCommException n) {
                        open = false;
                    }
                    if (!open) {
                        JOptionPane.showMessageDialog(NXJBrowser.this.frame, "Failed to connect");
                    } else {
                        NXJBrowser.this.showFiles(NXJBrowser.this.frame, nxts[row]);
                    }
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(connectButton);
        this.frame.getContentPane().add((Component)new JScrollPane(buttonPanel), "South");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void showFiles(final JFrame frame, NXTInfo nxt) {
        try {
            frame.setTitle(title + " : " + this.nxtCommand.getFriendlyName());
        }
        catch (IOException ioe) {
            this.showMessage("IOException getting friendly name");
        }
        frame.getContentPane().removeAll();
        this.fetchFiles();
        final FileModel fm = new FileModel(frame, this.files, this.numFiles);
        final JTable table = new JTable(fm);
        table.setAutoResizeMode(0);
        TableColumn col = table.getColumnModel().getColumn(0);
        col.setPreferredWidth(300);
        final JScrollPane tablePane = new JScrollPane(table);
        tablePane.setPreferredSize(new Dimension(605, 500));
        frame.getContentPane().add((Component)tablePane, "Center");
        JPanel buttonPanel = new JPanel();
        JButton deleteButton = new JButton("Delete Files");
        JButton uploadButton = new JButton("Upload file");
        JButton downloadButton = new JButton("Download file");
        JButton runButton = new JButton("Run program");
        JButton defragButton = new JButton("Defrag");
        JButton nameButton = new JButton("Set Name");
        buttonPanel.add(deleteButton);
        buttonPanel.add(uploadButton);
        buttonPanel.add(downloadButton);
        buttonPanel.add(runButton);
        buttonPanel.add(defragButton);
        buttonPanel.add(nameButton);
        frame.getContentPane().add((Component)new JScrollPane(buttonPanel), "South");
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                frame.setCursor(NXJBrowser.this.hourglassCursor);
                try {
                    for (int i = 0; i < fm.getRowCount(); ++i) {
                        Boolean b = (Boolean)fm.getValueAt(i, 4);
                        boolean deleteIt = b;
                        String fileName = (String)fm.getValueAt(i, 0);
                        if (!deleteIt) continue;
                        NXJBrowser.this.nxtCommand.delete(fileName);
                        fm.delete(i);
                        NXJBrowser.this.numFiles--;
                        --i;
                        table.invalidate();
                        tablePane.revalidate();
                    }
                }
                catch (IOException ioe) {
                    NXJBrowser.this.showMessage("IOException deleting files");
                }
                frame.setCursor(NXJBrowser.this.normalCursor);
            }
        });
        uploadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showOpenDialog(frame);
                if (returnVal == 0) {
                    frame.setCursor(NXJBrowser.this.hourglassCursor);
                    try {
                        File file = fc.getSelectedFile();
                        if (file.getName().length() > 20) {
                            NXJBrowser.this.showMessage("File name is more than 20 characters");
                        } else {
                            SendFile.sendFile(NXJBrowser.this.nxtCommand, file);
                            NXJBrowser.this.fetchFiles();
                            fm.setData(NXJBrowser.this.files, NXJBrowser.this.numFiles);
                            table.invalidate();
                            tablePane.revalidate();
                        }
                    }
                    catch (IOException ioe) {
                        NXJBrowser.this.showMessage("IOException uploading file");
                    }
                    frame.setCursor(NXJBrowser.this.normalCursor);
                }
            }
        });
        downloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int i = table.getSelectedRow();
                if (i < 0) {
                    return;
                }
                String fileName = ((NXJBrowser)NXJBrowser.this).files[i].fileName;
                int size = ((NXJBrowser)NXJBrowser.this).files[i].fileSize;
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(0);
                fc.setSelectedFile(new File(fileName));
                int returnVal = fc.showSaveDialog(frame);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    frame.setCursor(NXJBrowser.this.hourglassCursor);
                    NXJBrowser.this.getFile(file, fileName, size);
                    frame.setCursor(NXJBrowser.this.normalCursor);
                }
            }
        });
        defragButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                frame.setCursor(NXJBrowser.this.hourglassCursor);
                try {
                    NXJBrowser.this.nxtCommand.defrag();
                    NXJBrowser.this.fetchFiles();
                    fm.setData(NXJBrowser.this.files, NXJBrowser.this.numFiles);
                    table.invalidate();
                    tablePane.revalidate();
                    tablePane.repaint();
                }
                catch (IOException ioe) {
                    NXJBrowser.this.showMessage("IOException during defrag");
                }
                frame.setCursor(NXJBrowser.this.normalCursor);
            }
        });
        runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int i = table.getSelectedRow();
                if (i < 0) {
                    return;
                }
                String fileName = ((NXJBrowser)NXJBrowser.this).files[i].fileName;
                try {
                    NXJBrowser.this.runProgram(fileName);
                    System.exit(0);
                }
                catch (IOException ioe) {
                    NXJBrowser.this.showMessage("IOException running program");
                }
            }
        });
        nameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String name = JOptionPane.showInputDialog(frame, (Object)"New Name");
                if (name != null && name.length() <= 16) {
                    frame.setCursor(NXJBrowser.this.hourglassCursor);
                    try {
                        NXJBrowser.this.nxtCommand.setFriendlyName(name);
                        frame.setTitle(title + " : " + name);
                    }
                    catch (IOException ioe) {
                        NXJBrowser.this.showMessage("IOException setting friendly name");
                    }
                    frame.setCursor(NXJBrowser.this.normalCursor);
                }
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    private void fetchFiles() {
        block4: {
            this.numFiles = 0;
            try {
                this.files[0] = this.nxtCommand.findFirst("*.*");
                if (this.files[0] == null) break block4;
                this.numFiles = 1;
                for (int i = 1; i < 30; ++i) {
                    this.files[i] = this.nxtCommand.findNext(this.files[i - 1].fileHandle);
                    if (this.files[i] != null) {
                        ++this.numFiles;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                this.showMessage("IOException fetching files");
            }
        }
    }

    public void getFile(File file, String fileName, int size) {
        FileOutputStream out = null;
        int received = 0;
        try {
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            byte[] data;
            this.nxtCommand.openRead(fileName);
            do {
                data = this.nxtCommand.readFile((byte)0, size - received < 51 ? size - received : 51);
                out.write(data);
            } while ((received += data.length) < size);
            this.nxtCommand.closeFile((byte)0);
            out.close();
        }
        catch (IOException ioe) {
            this.showMessage("IOException downloading file");
        }
    }

    public void runProgram(String fileName) throws IOException {
        this.nxtCommand.startProgram(fileName);
    }

    public void showMessage(String msg) {
        JOptionPane.showMessageDialog(this.frame, msg);
    }
}

