/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.util.ArrayList;
import java.util.Collection;
import js.common.CLIToolProgressMonitor;
import js.common.ToolProgressMonitor;
import js.tinyvm.TinyVM;
import js.tinyvm.TinyVMException;
import lejos.pc.tools.NXJCommandLineParser;
import lejos.pc.tools.NXJUploadException;
import lejos.pc.tools.ToolsLogListener;
import lejos.pc.tools.ToolsLogger;
import lejos.pc.tools.Upload;
import org.apache.commons.cli.CommandLine;

public class NXJLinkAndUpload {
    private Collection<ToolsLogListener> fLogListeners;
    private NXJCommandLineParser fParser = new NXJCommandLineParser();
    private Upload fUpload;
    private TinyVM fTinyVM;

    public NXJLinkAndUpload() {
        this.fLogListeners = new ArrayList<ToolsLogListener>();
        this.fUpload = new Upload();
        this.fTinyVM = new TinyVM();
        this.fTinyVM.addProgressMonitor((ToolProgressMonitor)new CLIToolProgressMonitor());
    }

    public static void main(String[] args) {
        try {
            NXJLinkAndUpload instance = new NXJLinkAndUpload();
            instance.addToolsLogListener(new ToolsLogger());
            instance.run(args);
        }
        catch (Throwable t) {
            System.err.println("an error occurred: " + t.getMessage());
        }
    }

    public void run(String[] args) throws TinyVMException, NXJUploadException {
        CommandLine commandLine = this.fParser.parse(args);
        String binName = commandLine.getOptionValue("o");
        boolean run = commandLine.hasOption("r");
        boolean blueTooth = commandLine.hasOption("b");
        boolean usb = commandLine.hasOption("u");
        String name = commandLine.getOptionValue("n");
        String address = commandLine.getOptionValue("d");
        String firstArg = commandLine.getArgs()[0];
        int argCount = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-b") || args[i].equals("--bluetooth") || args[i].equals("-u") || args[i].equals("--usb")) continue;
            if (args[i].equals("-n")) {
                ++i;
                continue;
            }
            if (args[i].equals("--name")) {
                ++i;
                continue;
            }
            if (args[i].equals("-d")) {
                ++i;
                continue;
            }
            if (args[i].equals("--address")) {
                ++i;
                continue;
            }
            if (args[i].equals("-r") || args[i].equals("--run")) continue;
            ++argCount;
        }
        int index = 0;
        String[] tinyVMArgs = new String[argCount + 2];
        if (binName == null) {
            binName = firstArg + ".nxj";
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-b") || args[i].equals("--bluetooth") || args[i].equals("-u") || args[i].equals("--usb")) continue;
            if (args[i].equals("-n")) {
                ++i;
                continue;
            }
            if (args[i].equals("--name")) {
                ++i;
                continue;
            }
            if (args[i].equals("-d")) {
                ++i;
                continue;
            }
            if (args[i].equals("--address")) {
                ++i;
                continue;
            }
            if (args[i].equals("-r") || args[i].equals("--run")) continue;
            tinyVMArgs[index++] = args[i];
        }
        tinyVMArgs[argCount] = "-o";
        tinyVMArgs[argCount + 1] = binName;
        this.log("Linking...");
        this.fTinyVM.start(tinyVMArgs);
        this.log("Uploading...");
        int protocols = 0;
        if (blueTooth) {
            protocols |= 2;
        }
        if (usb) {
            protocols |= 1;
        }
        this.fUpload.upload(name, address, protocols, binName, run);
    }

    public void addToolsLogListener(ToolsLogListener listener) {
        this.fLogListeners.add(listener);
        this.fUpload.addLogListener(listener);
    }

    public void removeToolsLogListener(ToolsLogListener listener) {
        this.fLogListeners.remove(listener);
        this.fUpload.removeLogListener(listener);
    }

    public void addMonitor(ToolProgressMonitor monitor) {
        this.fTinyVM.addProgressMonitor(monitor);
    }

    public void removeMonitor(ToolProgressMonitor monitor) {
        this.fTinyVM.removeProgressMonitor(monitor);
    }

    private void log(String message) {
        for (ToolsLogListener listener : this.fLogListeners) {
            listener.logEvent(message);
        }
    }
}

