/*
 * Decompiled with CFR 0.152.
 */
package js.common;

import js.common.ToolProgressMonitor;

public class CLIToolProgressMonitor
implements ToolProgressMonitor {
    private boolean _verbose = false;

    public void operation(String message) {
        assert (message != null) : "Precondition: message != null";
        System.out.println(message);
    }

    public void log(String message) {
        if (!this._verbose) {
            return;
        }
        assert (message != null) : "Precondition: message != null";
        System.out.println(message);
    }

    public void progress(int progress) {
        assert (progress >= 0 && progress <= 1000) : "Precondition: progress >= 0 && progress <= 1000";
        String message = "\r  " + progress / 10 + "%\r";
        System.out.print(message);
        if (progress >= 1000) {
            System.out.println();
        }
    }

    public boolean isCanceled() {
        return Thread.currentThread().isInterrupted();
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }
}

