/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import js.tinyvm.TinyVMException;
import js.tinyvm.TinyVMType;
import js.tinyvm.WritableDataWithOffset;
import js.tinyvm.io.IByteWriter;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;

public class ConstantValue
extends WritableDataWithOffset {
    Object _value;
    private static final Logger _logger = Logger.getLogger("TinyVM");

    public ConstantValue(ConstantPool pool, Constant constant) {
        this._value = this.value(pool, constant);
        assert (this._value != null) : "Postconditon: result != null";
    }

    public Object value() {
        assert (this._value != null) : "Postconditon: result != null";
        return this._value;
    }

    public TinyVMType getType() {
        if (this._value instanceof Double) {
            return TinyVMType.T_LONG;
        }
        if (this._value instanceof Float) {
            return TinyVMType.T_FLOAT;
        }
        if (this._value instanceof Integer) {
            return TinyVMType.T_INT;
        }
        if (this._value instanceof Long) {
            return TinyVMType.T_LONG;
        }
        if (this._value instanceof String) {
            return TinyVMType.T_OBJECT;
        }
        assert (false) : "Check: known type";
        return null;
    }

    public int getLength() {
        if (this._value instanceof Double) {
            return 8;
        }
        if (this._value instanceof Float) {
            return 4;
        }
        if (this._value instanceof Integer) {
            return 4;
        }
        if (this._value instanceof Long) {
            return 8;
        }
        if (this._value instanceof String) {
            return ((String)this._value).getBytes().length;
        }
        assert (false) : "Check: known type";
        return -1;
    }

    public void dump(IByteWriter writer) throws TinyVMException {
        assert (writer != null) : "Precondition: writer != null";
        try {
            if (this._value instanceof Double) {
                double doubleValue = (Double)this._value;
                float floatValue = (float)doubleValue;
                if (doubleValue != 0.0 && Math.abs((doubleValue - (double)floatValue) / doubleValue) > 0.1) {
                    _logger.log(Level.WARNING, "Double " + doubleValue + " truncated to " + floatValue + "f.");
                }
                writer.writeInt(0);
                writer.writeInt(Float.floatToIntBits(floatValue));
            } else if (this._value instanceof Float) {
                writer.writeInt(Float.floatToIntBits(((Float)this._value).floatValue()));
            } else if (this._value instanceof Integer) {
                writer.writeInt((Integer)this._value);
            } else if (this._value instanceof Long) {
                long longValue = (Long)this._value;
                int intValue = (int)longValue;
                if ((long)intValue != longValue) {
                    _logger.log(Level.WARNING, "Long " + longValue + "L truncated to " + intValue + ".");
                }
                writer.writeInt(0);
                writer.writeInt(intValue);
            } else if (this._value instanceof String) {
                byte[] bytes = ((String)this._value).getBytes();
                writer.write(bytes);
            } else assert (false) : "Check: known entry type";
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    private Object value(ConstantPool pool, Constant constant) {
        assert (pool != null) : "Precondition: pool != null";
        assert (constant != null) : "Precondition: constant != null";
        Object result = null;
        if (constant instanceof ConstantDouble) {
            result = new Double(((ConstantDouble)constant).getBytes());
        } else if (constant instanceof ConstantFloat) {
            result = new Float(((ConstantFloat)constant).getBytes());
        } else if (constant instanceof ConstantInteger) {
            result = new Integer(((ConstantInteger)constant).getBytes());
        } else if (constant instanceof ConstantLong) {
            result = new Long(((ConstantLong)constant).getBytes());
        } else if (constant instanceof ConstantString) {
            result = new String(((ConstantString)constant).getBytes(pool));
        } else assert (false) : "Check: known type";
        assert (result != null) : "Postconditon: result != null";
        return result;
    }
}

